import Vue from 'vue'
import VueRouter from 'vue-router'
import Vuex from 'vuex'
import App from './App.vue'
import createStore from './store' // Vuex
import createRouter from './router/router'
import axiosServer from 'runner/request'
import UsePlugin from 'runner/common/plugins'
import customPlugin from './public/plugins'
import utils from 'utils'

Vue.use(Vuex)
Vue.use(VueRouter)
Vue.use(axiosServer)
Vue.use(UsePlugin)
Vue.use(customPlugin)

const router = createRouter() // 创建router
const store = createStore() // 创建Vuex

// 监听窗口缩放事件
const winResizeFn = utils.throttle(function () {
    const innerWH = {
        innerWidth: window.innerWidth,
        innerHeight: window.innerHeight
    }

    store.dispatch('setInnerWH', innerWH)
})

window.addEventListener('resize', winResizeFn)

new Vue({
    el: '#app',
    router,
    store,
    axiosServer,
    UsePlugin,
    customPlugin,
    template: '<App/>',
    components: { App }
})
