/**
 * @file apis/proxy 开发环境跨域配置
 */

module.exports = {
    host: '127.0.0.1',
    port: '8082', // 自定义端口号
    proxyTable: { // Vue开发环境跨域配置
        '/apis': {
            target: 'http://test-a.com',
            pathRewrite: {
                '^/apis': '/'
            },
            changeOrigin: true // 是否跨域 - 开启代理, 在本地会创建一个虚拟服务端, 然后发送请求的数据, 并同时接收请求的数据, 这样服务端和服务端进行数据的交互就不会有跨域问题
        }
    }
}
