import mixins from '../mixins'

// Vue插件(Vue plugin)
import ContentContainer from 'components/ContentContainer'
// 页面头
import Header from 'components/Header'
// 插件
import CountTo from 'components/CountTo.vue'

const UsePlugin = {}

/**
 * @method install Vue插件
 * @param {*} Vue
 * @param {Object} options, 注册插件初始化时传递的参数
 *      Vue.use(UsePlugin, { global: true })
 */
UsePlugin.install = function (Vue, options = {}) {
    Vue.mixin(mixins)
    // 内容容器
    Vue.component('content-container', ContentContainer)
    Vue.component('page-head', Header)
    // 数组滚动
    Vue.component('count-to', CountTo)
}

export default UsePlugin
