import Router from 'vue-router'
import routes from './routes'

// 处理服务端渲染内存泄漏问题
export default () => {
    return new Router({
        routes,
        // mode: 'history', // 去除#
        fallback: true, // 如果浏览器不支持history模式则自动转换为hash模式
        // base: '/base/', // 基础路径: 在路由配置的path前添加base: localhost:8000/base/app
        // 当前路由被激活的class
        linkActiveClass: 'active-link', // 匹配到部分路径 /login
        // 当前路由如果有子路由, 则当前如果匹配到子路由时
        // 则当前子级路由的上级路由都会匹配到linkActiveClass, 而不会匹配到linkExactActiveClass
        // 只有当前路由被完全匹配到才会显示linkExactActiveClass
        linkExactActiveClass: 'exact-active-link', // 匹配到完整路径 /login/exact
        // 路由跳转后的滚动事件
        scrollBehavior (to, from, savedPosition) {
            // console.log('scrollBehavior > ', to, from, savedPosition)
            // 如果已经在页面中滚动过, 则返回该路由时会自动滚动到之前的滚动位置
            if (savedPosition) {
                return savedPosition
            } else {
                // 默认返回到最顶部
                return { x: 0, y: 0 }
            }
        }
    // query转为json字符串
    // parseQuery (query) {
    //     // localhost:8000/a.html?a=xxx&b=yyy
    // },
    // // json对象转为query
    // stringifyQuery (obj) {}
    })
}
