
/**
 * @file mutations/index Vuex-mutations
 */
import allTitle from '../../public/utils/constant'

export default {
    openBullet: (state, data) => {
        // 打开弹框
        state.showBullet = true
        // 关闭其他所有插槽
        for (let key in state.bulletConTent) {
            state.bulletConTent[key] = false
        }
        // 变更弹框的title
        state.bulletTitle = allTitle.bulletTitle[data.type]
        // 打开对应弹框的插槽
        state.bulletConTent[data.type] = true
        // 根据data和type进行特殊处理
        if (data.type === 'schoolQuality' && data.schoolKey) {
            // 学校办学质量分析
            state.schoolKey = data.schoolKey
        }
    },
    closeBullet: (state) => {
        // 直接关闭弹框
        state.showBullet = false
    },

    // 教师个人能力发展情况
    setTeacherAbility (state, payload) {
        state.teacherAbility = payload.key || ''
    }
}
