
import apis from './apis' // 接口url
import { Axios } from './axiosPlugin' // axios请求

// 设置请求域名
const isPrd = process.env.NODE_ENV === 'production' // 默认生产环境
let domain = window.location.origin
if (!isPrd) {
    domain = 'http://192.168.0.135:8881' // 开发环境跨域默认配置
}

/**
 * @method fetch 获取接口请求
 * @param {String} url 接口路径url(不包含请求域名), 必须
 * @param {Object} params 请求入参, 非必须
 * @param {Object} extra 请求方式其他配置, 如: 配置请求方式 - method: GET, 非必须
 * @return {Promise} 返回Promise对象, 业务中自主处理
 */
const fetch = (url = '', params = {}, extra = {}) => {
    try {
        const currReqApi = apis[url] || ''
        // 请求地址配置错误
        if (!currReqApi) {
            const errInfo = {
                url,
                code: '1',
                message: '请求url不存在'
            }
            throw errInfo
        }
        const fullReqApi = domain + currReqApi
        console.log('fetch-fullReqApi > ', fullReqApi)
        return Axios({
            method: extra.method ? extra.method.toLocaleLowerCase : 'GET',
            url: fullReqApi,
            data: params,
            params // GET
        })
    } catch (error) {
        error.code === '1' && console.error(`当前请求url > ${error.url} 不存在`)
        throw error
    }
}

// 对axios的实例重新封装成一个plugin, 方便 Vue.use(xxxx)
export default {
    install (Vue, Option) {
    // 将fetch挂载在全局
        Vue.prototype.fetch = fetch
        // 当前环境
        Vue.prototype.isPrd = isPrd
    }
}
