
// 设置页面缩放比
export function refreshScale () {
    let baseWidth = document.documentElement.clientWidth
    let baseHeight = document.documentElement.clientHeight
    let appStyle = document.getElementById('app').style
    // let pageBgStyle = document.getElementById('pageBg').style
    let realRatio = baseWidth / baseHeight
    let designRatio = 16 / 9
    let scaleRate = baseWidth / 1920
    if (realRatio > designRatio) {
        scaleRate = baseHeight / 1080
    }
    appStyle.transformOrigin = 'left top'
    appStyle.transform = `scale(${scaleRate}) translateX(-50%)`
    appStyle.width = `${baseWidth / scaleRate}px`

    // pageBgStyle.transformOrigin = 'left top'
    // pageBgStyle.transform = `scale(${scaleRate}) translateX(-50%)`
    // pageBgStyle.width = `${baseWidth / scaleRate}px`
}
