import Vue from 'vue'
import VueRouter from 'vue-router'
import Vuex from 'vuex'
import App from './App.vue'
import createStore from './store' // Vuex
import createRouter from './router/router'
import axiosServer from './request'
import UsePlugin from './public/plugins'
// 引入css
import '../static/styles/reset.css'
import './public/utils/refreshSize'
Vue.use(Vuex)
Vue.use(VueRouter)
Vue.use(axiosServer)
Vue.use(UsePlugin)

const router = createRouter() // 创建router
const store = createStore() // 创建Vuex

new Vue({
    el: '#app',
    router,
    store,
    axiosServer,
    UsePlugin,
    template: '<App/>',
    components: { App }
})
