// Vue-loader配置
const { dev = {}, build = {} } = require('../config/config')

module.exports = (isDev) => {
    return {
        preserveWhitespace: true, // 清空多余空格
        extractCSS: !isDev, // 将.vue中的css单独抽离出来
        cssModules: { // 解决class命名空间冲突
            localIdentName: isDev ? '[path]-[name]-[hash:base64:5]' : '[hash:base64:5]', // class命名
            camelCase: true, // 驼峰class命名
        },
        // hotReload: false // 是否关闭组件热重载, 根据环境变量生成
        // 自定义loader模块
        loaders: isDev ? dev.vueloaderConf : build.vueloaderConf,
        preLoader: {
            js: ''
        },
        postLoader: {}
    }
}
