// Vue插件(Vue plugin)
import utils from '../utils/utils'
import { merge } from 'lodash'
import chartEl from '@/components/echarts' // 基础Echarts组件
import Layout from '@/components/Layout.vue' // 布局组件
import CountTo from '@/components/CountTo.vue'
import CountRoll from '@/components/CountRoll.vue'
import vueSeamlessScroll from 'vue-seamless-scroll'
import ContentContainer from '@/components/ContentContainer'
import * as echarts from 'echarts'

const UsePlugin = {}

/**
 * @method install Vue插件
 * @param {*} Vue
 * @param {Object} options, 注册插件初始化时传递的参数
 *      Vue.use(UsePlugin, { global: true })
 */
UsePlugin.install = function (Vue, options = {}) {
    // 全局公用方法
    Vue.prototype.utils = utils
    // 合并对象
    Vue.prototype.deepMerge = merge

    // 注册全局布局组件
    Vue.component('layout', Layout)
    // Echarts
    Vue.prototype.echarts = echarts
    // 基础Echarts组件
    Vue.component('chart-el', chartEl)
    // 数组滚动
    Vue.component('count-to', CountTo)
    // 数字分切滚动
    Vue.component('count-roll', CountRoll)
    // 无缝滚动插件
    Vue.component('vueSeamlessScroll', vueSeamlessScroll)
    // 内容容器
    Vue.component('content-container', ContentContainer)
}

export default UsePlugin
