// 该文件主要用来配置构建开发环境和生产环境差异化的参数

const _path = require('path')
const ExtractTextPlugin = require('extract-text-webpack-plugin')

// vue-loader基本配置
const baseVueLoaderConf = {
    // 引入postcss插件
    postcss: {
        config: {
            path: _path.resolve('../')
        }
    },
    // 转为require调用, 让webpack处理目标资源
    transformToRequire: {
        video: 'src',
        source: 'src',
        img: 'src',
        image: 'xlink:href'
    }
}

// vue-loader开发环境配置
const devVueLoaderConf = Object.assign({}, baseVueLoaderConf, {
    // loaders
    loaders: {
        css: ['vue-style-loader', 'css-loader'],
        less: ['vue-style-loader', 'css-loader', 'postcss-loader', 'less-loader']
    },
    cssSourceMap: true
})

// vue-loader生产环境配置
const buildVueLoaderConf = Object.assign({}, baseVueLoaderConf, {
    // loaders
    loaders: ExtractTextPlugin.extract({
        use: ['css-loader', 'postcss-loader', 'less-loader'],
        fallback: 'vue-style-loader'
    }),
    cssSourceMap: false
})

// 开发 / 生产环境 配置参数
module.exports = {
    dev: {
        publicPath: '/',
        devtoolType: '#cheap-module-eval-source-map',
        vueloaderConf: devVueLoaderConf,
        host: '127.0.0.1',
        port: '8081',
        proxyTable: {
            '/apis': {
                target: 'http://192.168.0.121:8881', // 接口域名
                pathRewrite: {
                    '^/apis': '/'
                },
                changeOrigin: true // 是否跨域 - 开启代理, 在本地会创建一个虚拟服务端, 然后发送请求的数据, 并同时接收请求的数据, 这样服务端和服务端进行数据的交互就不会有跨域问题
            }
        }
    },
    build: {
        // publicPath: '127.0.0.1', // 生产环境资源路径(部署后的访问url)
        publicPath: '../../',
        devtoolType: '#cheap-module-source-map',
        vueloaderConf: buildVueLoaderConf,
        host: '', // 接口请求域名
        staticPath: 'static'
    }
}
