// 此文件是项目打包服务,用来构建一个全量压缩包
// 命令: npm run build

'use strict'
const ora = require('ora')
const rm = require('rimraf')
const chalk = require('chalk')
const path = require('path')
const webpack = require('webpack')
const config = require('./webpack.prod.conf')
const rmFile = path.resolve(__dirname, '../dist')
// build start loading
const spinner = ora('building for production...')
spinner.start()

// 构建全量压缩包
rm(rmFile, function (err) {
    if (err) throw err
    webpack(config, function (err, stats) {
        spinner.stop()
        if (err) throw err
        process.stdout.write(
            stats.toString({
                colors: true,
                modules: false,
                children: false,
                chunks: false,
                chunkModules: false
            }) + '\n\n'
        )

        if (stats.hasErrors()) {
            console.log(chalk.red('  Build failed with errors.\n'))
            process.exit(1)
        }

        console.log(chalk.cyan('  Build complete.\n'))
        console.log(
            chalk.yellow(
                '  Tip: built files are meant to be served over an HTTP server.\n' +
                "  Opening index.html over file:// won't work.\n"
            )
        )
    })
})
