
import Vuex from 'vuex'
import defaultState from './state' // 默认数据
import mutations from './mutations'
import getters from './getters'
import actions from './actions'

const isDev = process.env.NODE_ENV === 'development'
console.warn('当前运行环境 > ', process.env.NODE_ENV)

// Vuex返回函数形式作用
// 便于SSR时使用, 如果每次重新渲染都使用同一个store会造成内存泄漏
export default () => {
    const store = new Vuex.Store({
        strict: isDev, // 开发环境中使用, 规范代码, 只能通过提交mutations的方式修改state
        state: defaultState,
        mutations,
        getters,
        actions,
        plugins: [],
        modules: {}
    })

    return store
}
