import mixins from '../mixins'

// Vue插件(Vue plugin)
import ContentContainer from 'components/ContentContainer'
// 头部标题
import Header from 'components/Header'
// 弹框
import BulletFrame from 'components/BulletFrame'

const UsePlugin = {}

/**
 * @method install Vue插件
 * @param {*} Vue
 * @param {Object} options, 注册插件初始化时传递的参数
 *      Vue.use(UsePlugin, { global: true })
 */
UsePlugin.install = function (Vue, options = {}) {
    Vue.mixin(mixins)
    // 内容容器
    Vue.component('content-container', ContentContainer)
    // 页面头部标题
    Vue.component('page-header', Header)
    // 弹框
    Vue.component('bullet-frame', BulletFrame)
}

export default UsePlugin
