import { getUnitMaxOccNum, separateDataAndUint, unifiedMaxAndMinValueAndStep } from "./privateTools";
//标准化输出  这里的东西禁止 乱改以及临时更改

/**
 * getStringOutData  获取文字列表返回结果
 * @param title  数据标题
 * @param data 数据体 格式:["txt...", "str..."]
 * @returns {title, dataList:[string...]}
 */
export function getStringOutData(title, data) {
    let dataList = [];
    data.forEach( (str, index) => {
        dataList.push({ key:index+1, value:str});
    });
    return { title, dataList};
}

/**
 * getChartData  获取图表返回结果
 * @param title 数据标题
 * @param data  数据体  格式：{"图表名称":{unit:"", dataInfo:[{key:"数据key", value:"数据值"}, {key:"数据key", value:"数据值"} ] } }
 * @param haveMoreY 是否有多个y轴  默认false
 * @returns {title:标题, dataList:[{unit:单位, total:总数, yMinValue:最小值, yMaxValue:最大值, yStepValue:间隔, dataList:[{key:value}] }]}
 */
export function getChartOutData(title, data) {
    let dataList = [];

    for (let chartName in data) {
        let { unit, dataInfo } = data[chartName];

        let addData:any = { title: chartName };

        let max = 0;
        let min = new Date().valueOf();
        let total = 0;
        let thisUnitStats = {};
        let onceDataList = [];
        for (let i = 0; i < dataInfo.length; i++) {
            let { key, value } = dataInfo[i];
            let { dataNum, dataUnit } = separateDataAndUint(value);
            min = Math.min(min, dataNum);
            max = Math.max(max, dataNum);
            thisUnitStats[dataUnit] = thisUnitStats[dataUnit] ? thisUnitStats[dataUnit] + 1 : 1;
            total += dataNum;

            onceDataList.push({key, value:dataNum, unit:dataUnit});
        }
        let statsUnit = getUnitMaxOccNum(thisUnitStats);
        let thisChartUnit = unit || statsUnit || "";

        addData["unit"] = thisChartUnit;
        addData["total"] = total;

        let {maxNumber, minNumber, stepNumber} = unifiedMaxAndMinValueAndStep(max, min);
        addData["yMinValue"] = minNumber;
        addData["yMaxValue"] = maxNumber;
        addData["yStepValue"] = stepNumber;
        addData["dataList"] = onceDataList;

        dataList.push(addData);
    }

    return {title, dataList};
}

/**
 * getListOutData  获取列表返回结果
 * @param title 数据标题
 * @param data 数据体  格式：[{key:"key1", values:[data1value1, data2value1, data3value1] }, {key:"key2", values:[data1value2, data2value2, data3value2] }]
 * @returns {title:数据标题, total:数据总条数, titleList:[表头...], valueList:[[数据列表...],[数据列表...]]}
 */
export function getListOutData(title, data) {
    let titleList = [];
    let valueList = [];

    let maxLength = 0;

    data.forEach( onceData => {
        let { key, values } = onceData;
        titleList.push(key);
        for (let i = 0; i < values.length; i++) {
            let value = values[i] || "";
            valueList[i] ? valueList[i].push(value) : valueList[i] = [value];
            Math.max(maxLength, i+1);
        }
    });
   return {title, total:0, titleList, valueList};
}

/**
 * getKeyNumberValueOutData  获取值为数值的键值返回结果
 * @param title 数据标题
 * @param data 数据体 格式:{key:value, key:value}
 * @returns { title:数据标题, dataList:[{key:"数据key", "value":"数据value", unit:"数据单位"}], total:数据值总数, count:数据总条数 }
 */
export function getKeyNumberValueOutData(title, data) {
    let dataList = [];
    let total = 0;
    let count = 0;

    for (let key in data) {
        let {dataNum, dataUnit} = separateDataAndUint(data[key]);
        total += dataNum;
        count += 1;
        let addData = {key, value:dataNum, unit:dataUnit};
        dataList.push(addData);
    }
    
    return { title, dataList, total, count };
}

/**
 * getKeyStringValueOutData  获取值为字符串的键值返回结果
 * @param title 数据标题
 * @param data 数据体 格式:{key:value, key:value}
 * @returns { title:数据标题, dataList:[{key:"数据key", "value":"数据value"}], count:数据总条数 }
 */
export function getKeyStringValueOutData(title, data) {
    let dataList = [];
    let count = 0;
    for (let key in data) {
        let addData = {key, value:data[key]};
        dataList.push(addData);
        count += 1;
    }
    return { title, dataList, count};
}


/**
 * getScatterFigureOutData  获取撒点图的返回结果
 * @param title 标题
 * @param data 数据 格式 [{x, y, name}, {x, y, name}, {x, y, name}, {x, y, name}]
 * @returns { title:标题, xMax:x轴最大值, xMin:x最小值, yMax:y最大值, yMin:y最小值, dataList:[{name:点的名称, value:[x坐标, y坐标]} ] };
 */
export function getScatterFigureOutData(title, data) {
    let dataList = [];
    let xMaxNumber = 0;
    let xMinNumber = new Date().valueOf();
    let yMaxNumber = 0;
    let yMinNumber = new Date().valueOf();

    data.forEach(item => {
        let { x, y, name } = item;
        let xCoordinateInfo = separateDataAndUint(x);
        let yCoordinateInfo = separateDataAndUint(y);

        const XNumber = xCoordinateInfo.dataNum;
        const YNumber = yCoordinateInfo.dataNum;

        yMaxNumber = Math.max(YNumber, yMaxNumber);
        yMinNumber = Math.min(YNumber, yMinNumber);
        xMaxNumber = Math.max(XNumber, xMaxNumber);
        xMinNumber = Math.min(XNumber, xMinNumber);

        let value = [XNumber, YNumber];
        dataList.push({ value, name:name || "" });

    });

    let xMaxMinInfo = unifiedMaxAndMinValueAndStep(xMaxNumber, xMinNumber);
    let yMaxMinInfo = unifiedMaxAndMinValueAndStep(yMaxNumber, yMinNumber);

    return { title, xMax:xMaxMinInfo.maxNumber, xMin:xMaxMinInfo.minNumber, yMax:yMaxMinInfo.maxNumber, yMin:yMaxMinInfo.minNumber, dataList };
}


