import { analysisExcelDataOfList, planarArrBecomeChartData, planarArrBecomeKeyValueData, planarArrBecomeListData, planarArrBecomeStringListData } from "../../cal/excelEnter";
import { getChartOutData, getKeyValueNotNumberOutData, getKeyValueNumberOutData, getListOutData, getScatterFigureOutData, getStringOutData } from "../../cal/out";
import { CHARTTYPEENUM, DATALISTTYPEENUM, KEYVALUETYPEENUM, SCATTERFIGURETYPEENUM, STRINGLISTTYPEENUM} from "../../config/enum";

/**
 * 生成随机数
 * @param min 最小值
 * @param max 最大值
 * @param stringType 是否为string类型 
 * @returns 
 */
 function rand(min,max,stringType) {
    if(stringType) {
        return (Math.floor(Math.random()*(max-min))+min).toString();
    }
    return Math.floor(Math.random()*(max-min))+min;
}


export function getKeyValueModule(typeName) {
    let dataList;
    let result = {};
    switch(typeName) {
        case KEYVALUETYPEENUM.键值对数值:
            dataList = generateArr(3, 2, 10, 100, "数据名称");
            result = getKeyValueNumberOutData("键值对数值数据", planarArrBecomeKeyValueData(dataList));
        break;
        case KEYVALUETYPEENUM.键值对字符:
            dataList = generateArr(3, 2, 10, 100, "数据名称", "", true);
            result = getKeyValueNotNumberOutData("键值对字符数据", planarArrBecomeKeyValueData(dataList));
        break;
    }
    
    return result;
}

export function getCharModule(typeName) {
    let dataList;
    let result = {};
    switch(typeName){
        case CHARTTYPEENUM.单Y单X:
            dataList = generateArr(6, 2, 10, 100, "key");
            result = getChartOutData("单Y单X数据", planarArrBecomeChartData(dataList));
        break;
        case CHARTTYPEENUM.单Y多X:
            dataList = generateArr(3, 6, 10, 100, "数据名称", "key");
            result = getChartOutData("单Y多X数据", planarArrBecomeChartData(dataList));
        break;
        case CHARTTYPEENUM.双Y多X:
            dataList = generateArr(3, 6, 10, 100, "数据名称", "key");
            result = getChartOutData("双Y多X数据", planarArrBecomeChartData(dataList));
        break;
    }
    
    return result;
}

export function getStringListModule(typeName) {
    let dataList;
    let result = {};
    switch(typeName){
        case STRINGLISTTYPEENUM.字符列表:
            dataList = generateArr(5, 2, 10, 100, "文本", "标题", true);
            result = getStringOutData("字符列表数据", planarArrBecomeStringListData(dataList));
        break;
    }
    
    return result;
}

export function getScatterFigureModule(typeName) {
    let dataList;
    let result = {};
    switch(typeName){
        case SCATTERFIGURETYPEENUM.撒点图:
            dataList = generateArr(5, 2, 10, 100, "", "y", false, "x");
            result = getScatterFigureOutData("撒点图数据", analysisExcelDataOfList(dataList));
        break;
    }
    
    return result;
}

export function getdataListModule(typeName) {
    let dataList;
    let result = {};
    switch(typeName){
        case DATALISTTYPEENUM.数据列表:
            dataList = generateArr(5, 4, 10, 100, "数据名称", "标题");
            result = getListOutData("列表数据", planarArrBecomeListData(dataList));
        break;
    }
    
    return result;
}

export function generateArr(x, y, min, max, xName="", yName="", stringType=false, titleName="数据名称") {
    var arr = [];
    arr[0] = [titleName]; 
    for(var i = 1;i < x; i++){
        arr[i] = []; 
        arr[i][0] = xName+i;
        for(var j = 1;j < y; j++){
            if(yName!="") {
                arr[0][j] = yName+j;
            } else {
                arr[0][j] = "数据值";
            }
            if (stringType) {
                arr[i][j] = rand(min, max, stringType);
            }
            arr[i][j] = "value"+j;
        }   
    }
    return arr;
}

