import { CHARTTYPEENUM, DATALISTTYPEENUM, KEYVALUETYPEENUM, SCATTERFIGURETYPEENUM, STRINGLISTTYPEENUM } from "../config/enum";
import { getCharModule, getdataListModule, getKeyValueModule, getScatterFigureModule, getStringListModule } from "../data/simulate/dataModule";

export function getData(req, res) {
    let typeName = req.query.typeName;
    
    let ret:any = {};

    let moduleData;

    switch(parseInt(typeName)) {
        case KEYVALUETYPEENUM.键值对字符,KEYVALUETYPEENUM.键值对数值:
            moduleData = getKeyValueModule(typeName);
            ret["keyValueApi"] = moduleData;
        break;
        case CHARTTYPEENUM.单Y单X,CHARTTYPEENUM.单Y多X,CHARTTYPEENUM.双Y多X:
            moduleData = getCharModule(typeName);
            ret["charApi"] = moduleData;
        break;
        case STRINGLISTTYPEENUM.字符列表:
            moduleData = getStringListModule(typeName);
            ret["dataListApi"] = moduleData;
        break;
        case SCATTERFIGURETYPEENUM.撒点图:
            moduleData = getScatterFigureModule(typeName);
            ret["stringListApi"] = moduleData;
        break;
        case DATALISTTYPEENUM.数据列表:
            moduleData = getdataListModule(typeName);
            ret["scatterFigureApi"] = moduleData;
        break;
        default:
            moduleData = getKeyValueModule(2);
            ret["defaultApi"] = moduleData;
        break;
    }

    
    res.send(ret);
}
