import { analysisExcelDataOfList, planarArrBecomeChartData, planarArrBecomeKeyValueData, planarArrBecomeListData, planarArrBecomeStringListData } from "../../cal/excelEnter";
import { getChartOutData, getKeyValueNotNumberOutData, getKeyValueNumberOutData, getListOutData, getScatterFigureOutData, getStringOutData } from "../../cal/out";
import { CHARTTYPEENUM, DATALISTTYPEENUM, KEYVALUETYPEENUM, SCATTERFIGURETYPEENUM, STRINGLISTTYPEENUM} from "../../config/enum";

/**
 * 生成随机数组
 * @param min 最小值
 * @param max 最大值
 * @returns 
 */
 function rand(min,max) {
    return Math.floor(Math.random()*(max-min))+min;
}


export function getKeyValueModule(typeName) {
    let dataList = [];
    let result = {};
    switch(typeName){
        case KEYVALUETYPEENUM.键值对数值:
            dataList = [["数据名称","数据值"],["数据名称1",36],["数据名称2",15]];
            result = getKeyValueNumberOutData("键值对数值数据", planarArrBecomeKeyValueData(dataList));
        break;
        case KEYVALUETYPEENUM.键值对字符:
        case KEYVALUETYPEENUM.雷达图:
            dataList = [["数据名称","数据值"],["数据名称1","数据值1"],["数据名称2","数据值2"]];
            result = getKeyValueNotNumberOutData("键值对字符数据", planarArrBecomeKeyValueData(dataList));
        break;
    }
    
    return result;
}


export function getCharModule(typeName) {
    let dataList = [];
    let result = {};
    switch(typeName){
        case CHARTTYPEENUM.单Y单X:
            dataList = [["数据名称", "数据值"],["key1", "value1"],["key2", "value2"],["key3", "value3"],["key4", "value4"],["key5", "value5"]];
            result = getChartOutData("图表数据", planarArrBecomeChartData(dataList));
        break;
        case CHARTTYPEENUM.单Y多X:
            dataList = [
                ["数据名称", "key1", "key2", "key3", "key4", "key5"],
                ["数据名称a", "a的value1", "a的value2", "a的value3", "a的value4", "a的value5"],
                ["数据名称b", "b的value1", "b的value2", "b的value3", "b的value4", "b的value5"],
            ];
            result = getChartOutData("图表数据", planarArrBecomeChartData(dataList));
        break;
        case CHARTTYPEENUM.双Y多X:
            dataList = [
                ["数据名称", "key1", "key2", "key3", "key4", "key5"],
                ["数据名称a", "a的value1", "a的value2", "a的value3", "a的value4", "a的value5"],
                ["数据名称b", "b的value1", "b的value2", "b的value3", "b的value4", "b的value5"],
            ];
            result = getChartOutData("图表数据", planarArrBecomeChartData(dataList));
        break;
    }
    
    return result;
}

export function getStringListModule(typeName) {
    let dataList = [];
    let result = {};
    switch(typeName){
        case STRINGLISTTYPEENUM.字符列表:
            dataList = [
                ["数据类型", "标题"],["文本", "value1"],["文本", "value2"],["文本", "value3"],["文本", "value4"],["文本", "value5"]
            ];
            result = getStringOutData("字符列表数据", planarArrBecomeStringListData(dataList));
        break;
    }
    
    return result;
}


export function getScatterFigureModule(typeName) {
    let dataList = [];
    let result = {};
    switch(typeName){
        case SCATTERFIGURETYPEENUM.撒点图:
            dataList = [
                ["x", "y"], 
                ["a的x", "a的y"], 
                ["b的x", "b的y"], 
                ["c的x", "c的y"],
                ["d的x", "d的y"], 
                ["e的x", "e的y"], 
            ];
            result = getScatterFigureOutData("撒点图数据", analysisExcelDataOfList(dataList));
        break;
    }
    
    return result;
}

export function getdataListModule(typeName) {
    let dataList = [];
    let result = {};
    switch(typeName){
        case DATALISTTYPEENUM.数据列表:
            dataList = [
                ["数据名称", "标题1", "标题2", "标题3"],
                ["数据名称a", "标题1的value1", "标题2的value1", "标题3的value1"],
                ["数据名称b", "标题1的value2", "标题2的value2", "标题3的value2"],
                ["数据名称c", "标题1的value3", "标题2的value3", "标题3的value3"],
                ["数据名称d", "标题1的value4", "标题2的value4", "标题3的value4"],
                ["数据名称e", "标题1的value5", "标题2的value5", "标题3的value5"]
            ];
            result = getListOutData("列表数据", planarArrBecomeListData(dataList));
        break;
    }
    
    return result;
}






export function testArr(x, y, xName, yName) {
    var arr = [];
    for(var i = 1;i < x; i++){
        arr[0] = ["数据名称"]; 
        arr[i] = []; 
        arr[i][0] = xName+i;
        for(var j = 1;j < y; j++){
            arr[0][j] = yName+j;
            arr[i][j] = rand(10 ,100);
        }   
    }
}