//仅限cal中使用的工具  禁止做任何修改

/**
 * separateDataAndUint 截取字符串中的单位
 * @param str 待处理字符串
 * @returns {dataNumber:数据, dataUnit:单位}
 */
export function separateDataAndUint(str) {
    str = `${str}`;
    if (!str) return {dataNum:0, dataUnit:""};
    let dataNum = parseFloat(str.replace(/[\u4E00-\u9FA5a-zA-Z]+/,""));
    let dataUnit = str.replace(/^(-)?\d+(\.\d+)?/, "");
    return {dataNum, dataUnit};
}

/**
 * getUnitMaxOccNum  获取出现次数最多的单位
 * @param unitMap 统计后的出现过的单位情况 结构{unit:出现次数}
 * @returns 出现次数最多的单位
 */1
export function getUnitMaxOccNum(unitMap) {
    let max = 0;
    let maxUnit = "";
    for (let unit in unitMap) {
        let occNum = unitMap[unit];
        if (occNum > max) {
            max = occNum;
            maxUnit = unit;
        }
    }
    return maxUnit;
}

/**
 * unifiedMaxAndMinValueAndStep 求最大最小值以及间隙 固定分10份
 * @param max 最大
 * @param min 最小
 * @returns {maxNumber:向上留值最大, minNumber:向下留值最小, stepNumber:间隔};
 */
export function unifiedMaxAndMinValueAndStep(max, min) {
    let maxNumber = Math.ceil(max);
    let minNumber = Math.floor(min);

    function getNumberInLength(length) {
        let lengthCount = 1;
        for (let i = 1; i < length; i++) {
            lengthCount = lengthCount * 10;
        }
        return lengthCount;
    }

    let maxNumberLength = getNumberInLength(`${maxNumber}`.length);
    let minNumberLength = getNumberInLength(`${minNumber}`.length);
    
    if (maxNumber <= 10 && maxNumber > 0) maxNumber = 10;
    else maxNumber = Math.ceil(maxNumber / maxNumberLength) * maxNumberLength;
    minNumber =  Math.floor(minNumber / minNumberLength) * minNumberLength;
    
    let stepNumber = Math.ceil((maxNumber - minNumber) / 10);

    return {maxNumber, minNumber, stepNumber};
}