import { analysisExcelDataOfList, planarArrBecomeChartData, planarArrBecomeKeyValueData, planarArrBecomeListData, planarArrBecomeStringListData } from "../../cal/excelEnter";
import { getChartOutData, getKeyValueNotNumberOutData, getKeyValueNumberOutData, getListOutData, getScatterFigureOutData, getStringOutData } from "../../cal/out";
import { MODULEENUM} from "../../config/enum";

/**
 * 生成随机数
 * @param min 最小值
 * @param max 最大值
 * @param stringType 是否为string类型 
 * @returns 
 */
 function rand(min,max) {
    return Math.floor(Math.random()*(max-min))+min;
}


export function getKeyValueModule() {
    let dataList;
    dataList = generateArr(5, 2, 10, 100, "数据名称");
    let result = getKeyValueNumberOutData("键值数据", planarArrBecomeKeyValueData(dataList));
    return result;
}

export function getCharModule() {
    let dataList;
    dataList = generateArr(5, 6, 10, 100, "数据名称", "key");
    let result = getChartOutData("图表数据", planarArrBecomeChartData(dataList));
    return result;
}

export function getStringListModule() {
    let dataList;
    dataList = generateArr(5, 2, 10, 100, "文本", "标题");
    let result = getStringOutData("字符列表数据", planarArrBecomeStringListData(dataList));
    return result;
}

export function getScatterFigureModule() {
    let dataList;
    dataList = generateScatterFigureArr(5, 3, 10, 100, "x");
    let result = getScatterFigureOutData("撒点图数据", analysisExcelDataOfList(dataList, false));
    return result;
}

export function getDataListModule() {
    let dataList;
    dataList = generateArr(5, 3, 10, 100, "数据名称", "标题");
    let result = getListOutData("列表数据", planarArrBecomeListData(dataList, true));
    return result;
}

export function getRadarModule() {
    let dataList;
    let result;
    return result;
}


export function generateArr(x, y, min, max, xName="", yName="", titleName="数据名称") {
    var arr = [];
    arr[0] = [titleName]; 
    for(var i = 1;i <= x; i++){
        arr[i] = []; 
        arr[i][0] = xName+i;
        for(var j = 1;j < y; j++){
            if(yName!="") {
                arr[0][j] = yName+j;
            } else {
                arr[0][j] = "数据值";
            }
            arr[i][j] = rand(min, max);
        }   
    }
    return arr;
}

export function generateScatterFigureArr(x, y, min, max, titleName="数据名称") {
    var arr = [];
    arr[0] = [titleName]; 
    arr[0][1] = "y"; 
    for(var i = 1;i <= x; i++){
        arr[i] = [];
        for(var j = 0;j < y; j++){
            arr[0][2] = "name";
            arr[i][j] = rand(min, max);
        }   
        arr[i][2] = "name"+i;
    }
    return arr;
}
