//标准化exce输入


/**
 * planarArrBecomeKeyValueData  二维数组转keyvalue需要的结构
 * @param dataList 数据列表 格式 [[标题1，标题2],[key1,value1],[key2, value2]] or [[标题1, key1, key2],[标题2,value1, value2] ]
 * @param titleInY 标题是否垂直排列 or key是否横向排列 or key在x轴上 and 即当为false时输入为（默认为false）:[[标题1，标题2],[key1,value1],[key2, value2]]
 * @returns {key:value}
 */
export function planarArrBecomeKeyValueData(dataList, titleInY = false) {
    let result:any = {};
    if (!titleInY) { //title 在x轴上
        for (let y = 1; y < dataList.length; y++) {
            let childList = dataList[y];
            let key = childList[0];
            let value = childList[1] || null;
            result[key] = value;
        }
    } else {
        let keyList = dataList[0];
        let valueList = dataList[1];
        for (let i = 1; i < keyList.length; i++) {
            let key = keyList[i];
            let value = valueList[i] || null;
            result[key] = value;
        }
    }

    return result;
}

/**
 * planarArrBecomeChartData  二维数组转chart需要的结构
 * @param dataList 数据列表 格式 [[标题说明占位符, key1, key2, key3],[数据名称a, a的value1, a的value2, a的value3],[数据名称b, b的value1, b的value2, b的value3]] 
 * or [[标题说明占位符, 数据名称a, 数据名称b ],[key1, a的value1, b的value1],[key2, a的value2, b的value2]]
 * @param titleInY key是否在y轴上 默认为false时 [[标题说明占位符, 数据名称a, 数据名称b ],[key1, a的value1, b的value1],[key2, a的value2, b的value2]]
 * @returns {"图表名称":{unit:"", dataInfo:[{key:"数据key", value:"数据值"}, {key:"数据key", value:"数据值"} ] } }
 */
export function planarArrBecomeChartData(dataList, titleInY = false) {
    let result = {};
    if (!titleInY) {
        let keyList = dataList[0];
        for (let y = 1; y < dataList.length; y++) {
            let subList = dataList[y];
            let dataName = subList[0];
            let dataInfo = [];
            for (let x = 1; x < subList.length; x++) {
                let key = keyList[x] || `未知key${x}`;
                let value = subList[x];
                dataInfo.push({ key, value });
            }

            result[dataName] = {unit:'', dataInfo};
        }
    } else {
        let dataIndexMap = {};

        let dataNameList = dataList[0];
        for (let x = 1; x < dataNameList.length; x++) {
            let dataName = dataNameList[x];
            dataIndexMap[x] = dataName;
            result[dataName] = {unit:'', dataInfo:[]};
        }

        for (let y = 1; y < dataList.length; y++) {
            let subList = dataList[y];
            let key = subList[0];
            for (let x = 1; x < subList.length; x++) {
                let thisDataName = dataIndexMap[x];
                let value = subList[x];
                result[thisDataName].dataInfo.push( {key, value} );
            }
        }

    }

    return result;
}

/**
 * planarArrBecomeStringListData  二维数组转字符列表需要的结构
 * @param dataList dataList 数据列表 格式 [[标题1，标题2],[文本占位符,value1],[文本占位符, value2]] or [[标题1, 文本占位符, 文本占位符],[标题2,value1, value2] ]
 * @param titleInY titleInY 标题是否垂直排列 or key是否横向排列 or key在x轴上 and 即当为false时输入为（默认为false）:[[标题1，标题2],[key1,value1],[key2, value2]]
 * @returns ["文本1", "文本2"]
 */
export function planarArrBecomeStringListData(dataList, titleInY = false) {
    let result = [];
    if (!titleInY) { //title 在x轴上
        for (let y = 1; y < dataList.length; y++) {
            let childList = dataList[y];
            let value = childList[1] || '';
            result.push(value);
        }
    } else {
        let valueList = dataList[1];
        for (let i = 1; i < valueList.length; i++) {
            let value = valueList[i] || '';
            result.push(value);
        }
    }

    return result;
}
/**
 * planarArrBecomeListData  二维数组转列表需要的结构
 * @param dataList 数据列表 格式 [[标题1, 标题2, 标题3],[a的value1, a的value2, a的value3],[b的value1, b的value2, b的value3]] or
 *  [[标题1, a的值1, b的值1],[标题2, a的值2, b的值2],[标题3, a的值3, b的值3]]
 * @param titleInY  titleInY 标题是否垂直排列 or key是否横向排列 or key在x轴上 and 即当为false时输入为（默认为false）:[[标题1, 标题2, 标题3],[a的value1, a的value2, a的value3],[b的value1, b的value2, b的value3]]
 * @returns 返回 [{key:"标题1", values:[a的value1, b的value1, c的value1] }, {key:"标题2", values:[a的value2, b的value2, c的value2] }]
 */
export function planarArrBecomeListData(dataList, titleInY = false) {
    let result = [];

    if (!titleInY) {
        let dataTitle = dataList[0];
        for (let y = 1; y < dataList.length; y++) {
            let subValueList = dataList[y];
    
            for (let x = 0; x < subValueList.length; x++){
                let value = subValueList[x];
                let key = dataTitle[x];
                if ( !result[x] ) result[x].push({key, values:[] });
                result[x].values.push(value);
            }
        }

    } else {
        for (let y = 0; y < dataList.length; y++) {
            let subValueList = dataList[y];
            result.push({
                key:subValueList[0],
                values:subValueList.slice(1, subValueList.length)
            })
        }
    }
   
    return result;
}


/**
 * analysisExcelDataOfList  将excel解出来的数据块按需求解析成可用数据
 * @param dataList excel解出来的数据 [[x, y, name], [x值, y值, name值], [x, y, name], [x, y, name]] or
 * [[x, a的x, b的x, c的x], [y, a的y, b的y, c的y ], [name,  a的name, b的name, c的name] ]
 * @param titleInY 第一个表头数据是否横向排列
 * @returns 返回  [{x:a的x, y:a的y, name:a的name}, {x:b的x, y:b的y, name:b的name}, {x:c的x, y:c的y, name:c的name} ]
 */
 export function analysisExcelDataOfList(dataList, titleInY = true) {
    let result = [];
    if (!titleInY) {//在y轴上排列
        for (let i = 1; i < dataList.length; i++) {
            let itemList = dataList[i];//[1,5,"测试数据"]
            let x = itemList[0];
            let y = itemList[1];
            let name = itemList[2] || "";

            if (isNaN(x) || isNaN(y) ) continue;

            result.push({ x, y, name});
        }
    } else {
        for (let i = 0; i < dataList.length; i++) {
            let list = [];
            let subList = dataList[i];
            let keys = subList[0];
            for (let x = 1; x < subList.length; x++){
                let itemList = {};
                let addInfo:any = {};
                addInfo[keys] = keys;
                itemList[addInfo[keys]] = subList[x];
                list.push(itemList);
            }
            result.push(list);
        }
        
    }

    return result;
}

/**
 * analysisExcelDataOfMoreObject  将excel解出来的数据块按需求解析成可用数据
 * @param dataList excel解出来的数据 
 * @param isJumpTitle 是否跳过解析表头
 * @param headerInx 第一个表头数据是否横向排列
 * @returns 返回 {"第一个表头数据":{"表头数据":值...} }
 */
 export function analysisExcelDataOfMoreObject(dataList, titleInY = false) {
    let result = {};
    let titleList = dataList[0];
    if (!titleInY) {

        for (let y =1; y < dataList.length; y++) {
            let dataTitle = dataList[y][0];
            let thisData = {};
            for (let x = 1; x < dataList[y].length; x++) {
                let key = titleList[x];
                thisData[key] = dataList[y][x];
            }
            result[dataTitle] = thisData;
        }
    } else {
        let indexKeyMap = {};
        titleList.forEach((thisTitle, index) => {
            if (!index) return;
            indexKeyMap[index] = thisTitle;
            result[thisTitle] = {};
        });

        for (let y =1; y < dataList.length; y++) {
            let thisKey = dataList[y][0];
            for (let x = 1; x < dataList[y].length; x++) {
                let thisTitle = indexKeyMap[x];
                result[thisTitle][thisKey] = dataList[y][x];
            }
           
        }
    }
    return result;
}

