import { MODULEENUM } from "../config/enum";
import { getCharModule, getDataListModule, getKeyValueModule, getRadarModule, getScatterFigureModule, getStringListModule } from "../data/simulate/dataModule";

export function getData(req, res) {
    let typeName = req.query.typeName;
    
    let ret:any = {};

    let moduleData;

    switch(parseInt(typeName)) {
        case MODULEENUM.键值数据:
            moduleData = getKeyValueModule();
            ret["keyValueApi"] = moduleData;
        break;
        case MODULEENUM.图表数据:
            moduleData = getCharModule();
            ret["charApi"] = moduleData;
        break;
        case MODULEENUM.字符列表:
            moduleData = getStringListModule();
            ret["dataListApi"] = moduleData;
        break;
        case MODULEENUM.撒点图:
            moduleData = getScatterFigureModule();
            ret["stringListApi"] = moduleData;
        break;
        case MODULEENUM.数据列表:
            moduleData = getDataListModule();
            ret["scatterFigureApi"] = moduleData;
        break;
        case MODULEENUM.雷达图:
            moduleData = getRadarModule();
            ret["scatterFigureApi"] = moduleData;
        break;
        default:
            moduleData = getKeyValueModule();
            ret["keyValueApi"] = moduleData;
        break;
    }

    
    res.send(ret);
}
