
import { systemConfig } from "../config/serverConfig";
import { BizError } from "../util/bizError";
import { createDbConnect } from "./dbConnect";
import { initTable } from "./tableInit";
var baseDB;

export async function initDB() {
    //如果配置了mongoServerConstVal 才会连接mongo
    if (systemConfig.mongodbStr) {
        console.log(systemConfig.mongodbStr)
        baseDB = await createDbConnect(systemConfig.mongodbStr).catch(err => {
            throw err
        });
    
        await initTable();
        console.log('init mongodb success');
    } else {
        throw new BizError("xml中未配置mongo连接字符串 无法连接到mongodb");
    }
   
}

export { baseDB };
