import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const fuHuaQiTaskSchema = new Schema({
    key:{type:String, index:true},//任务标识  格式为:YYYYMM
    type: {type:Number,index: true},//任务类型
    taskId:String,//任务id
    fuHuaQiUscc:String,//任务所属孵化器id
    createTime:Number,//提交时间
    // relevanceId:String,//任务关联的表 financing 或 enterprise 的id  弃用
});

var fuHuaQiTaskModel;
export function initModel(){
    fuHuaQiTaskModel = baseDB.model('fuHuaQiTask', fuHuaQiTaskSchema);
}

/**
 * 通过统一信用代码和任务日期标识 查询孵化器任务
 * @param uscc 孵化器代码
 * @param key 任务日期标识
 * @returns 
 */
export async function findFuHuaQiTaskByKeyAndUscc(uscc:string, key:string) {
    let findList = await fuHuaQiTaskModel.find({uscc, key}).exec() || [];
    let taskMap = {};
    findList.forEach(item => {
        taskMap[item.key] = item;
    });
    return taskMap;
}

/**
 * 归档时添加任务信息
 * @param uscc 统一信用代码
 * @param key 任务日期标识
 * @param taskId 任务id
 * @param type 任务类型
 */
export async function createTaskData(uscc:string, key:string, taskId:string, type:number ) {
    let addInfo = {key, type, taskId, fuHuaQiUscc:uscc, createTime:new Date().valueOf()};
    await fuHuaQiTaskModel.create(addInfo);
}

