import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const monthTableSchema = new Schema({
    taskId:String,//任务id
    name:String,//任务名称
    fuHuaQiUscc:String,//任务所属孵化器id
    occupancyRate:Number,//出租率
    createTime:Number,//创建时间
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
});

var monthTableModel;
export function initModel(){
    monthTableModel = baseDB.model('monthTable', monthTableSchema);
    monthTableModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await monthTableModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

/**
 * 通过taskId 获取此次任务添加的月度列表
 * @param taskId 
 * @returns 
 */
export async function findmonthTableListByTaskId(taskId:string) {
    return await monthTableModel.find({taskId}).exec();
}

/**
 * 通过taskId 获取此次月度任务
 * @param taskId 
 * @returns 
 */
export async function findmonthTableByTaskId(taskId:string) {
    let monthTableInfo = await monthTableModel.selectOnceData({taskId}).exec();
    return monthTableInfo;
}

