import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const financingSchema = new Schema({
    uscc:{type:String, index:true},//统一信用代码
    name:String,//企业名称
    taskId:{type:String, index:true},//任务id
    createTime:Number,//入库时间
    financingTime:Number,//获得融资时间
    financingAmount:Number,//融资金额(万元)
    investmentInstitutionsName:String,//投资机构名称
    timeToObtainInvestment:Number,//获得投资时间
    fuHuaQiInvestment:{type:Boolean, default:false},//孵化器是否投资
    fuHuaQiInvestmentAmount:Number,//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:Number,//孵化器投资方式
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
});

var financingModel;
export function initModel(){
    financingModel = baseDB.model('financing', financingSchema);
}

/**
 * 通过taskId 获取此次任务添加的融资列表
 * @param taskId 
 * @returns 
 */
export async function findFinancingListByTaskId(taskId:string) {
    return await financingModel.find({taskId}).exec();
}

/**
 * 修改特定taskId的锁为true
 * @param taskId 任务id
 */
export async function updateFinancingDraftLock(taskId:string) {
    return await financingModel.update({taskId}, {$set:{draftLock:true}}, {upsert:true});
}