import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const enterpriseSchema = new Schema({
    name: {type:String, index: true},//企业名称
    taskId:{type:String, index:true},//绑定的任务id
    uscc:{type:String, index: true},//统一信用代码
    fuHuaQiUscc:{type:String, index:true},//孵化器统一信用代码
    industry:[Number],//领域

    logonTime:Number,//注册时间
    logonAdd:String,//注册地址
    operatingAdd:String,//经营地址
    isPhysicalPresence:{type:Boolean, default:true},//是否实地孵化
    
    firstIncubationTime:Number,//首次入孵时间
    isNaturalPersonHolding:{type:Boolean, false:true},//是否自然人控股企业
    leasedArea:Number,//租赁面积（平方米）
    oldLogonAdd:String,//迁入前注册地址
    timeOfImmigration:Number,//迁入时间
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
});

var enterpriseModel;
export function initModel(){
    enterpriseModel = baseDB.model('enterprise', enterpriseSchema);
}

/**
 * 通过taskId 获取此次任务添加的企业列表
 * @param taskId 
 * @returns 
 */
export async function findEnterpriseListByTaskId(taskId:string) {
    return await enterpriseModel.find({taskId}).exec();
}

/**
 * 修改特定taskId的锁为true
 * @param taskId 任务id
 */
export async function updateEnterpriseDraftLock(taskId:string) {
    return await enterpriseModel.update({taskId}, {$set:{draftLock:true}}, {upsert:true});
}

export async function createEnterprise() {

}