/**
 * 孵化器用户逻辑层 
 * 作者: 陈金晶
 * 主要包括有 孵化器账号的登录 
 * 预留好  重置密码  退出登录 接口  
 */
import { ERRORENUM } from "../../config/errorEnum";
import * as fuhuaqiData from "../../data/fuHuaQi/fuhuaqi"
import { BizError } from "../../util/bizError";

const md5 = require("md5");

/**
 * 登录
 * @param uscc 登录账号
 * @param pwd 密码
 * @returns 
 */
export async function login(uscc:string, pwd:string):Promise<object> {
    if (typeof uscc != "string" || typeof pwd != "string") throw new BizError(ERRORENUM.参数错误, uscc, pwd);
    let fuhuaqiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    if(!fuhuaqiInfo) throw new BizError(ERRORENUM.未找到数据);

    let checkPwd = getPwdMd5(fuhuaqiInfo.uscc, pwd);
    if (fuhuaqiInfo.pwd != checkPwd) throw new BizError("密码不正确");
    let fuhuaqiUserInfo = {
        uscc: fuhuaqiInfo.uscc,
        name: fuhuaqiInfo.name
    };
    
    return fuhuaqiUserInfo;
}

//重置密码
export async function changePassword(uscc:string, pwd:string, newPwd:string) {
    if (typeof uscc != "string" || typeof pwd != "string" || typeof newPwd != "string") throw new BizError(ERRORENUM.参数错误, uscc, pwd, newPwd);
    let reg = new RegExp("[`~!@#$^&*()=|{}':;',\\[\\].<>/?~！@#￥……&*（）——|{}【】‘；：”“'。，、？]");
    if (reg.test(newPwd)) {
        throw new BizError("密码不允许有特殊字符");
    }
    let fuhuaqiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    if (!fuhuaqiInfo) throw new BizError(ERRORENUM.未找到数据);
    let checkPwd = getPwdMd5(fuhuaqiInfo.uscc, pwd);
    if (fuhuaqiInfo.pwd != checkPwd) throw new BizError("密码错误");
    fuhuaqiInfo.pwd = getPwdMd5(uscc, newPwd);
    await fuhuaqiInfo.save();

    return {msg: "修改成功", isOk:true};
}


/**
 * 退出登录
 * @param uscc 登录账号
 * @returns 
 */
export async function logout(uscc:string):Promise<object> {
    if (typeof uscc != "string") throw new BizError(ERRORENUM.参数错误, uscc);
    let fuhuaqiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    await fuhuaqiInfo.save();
    return {msg: "退出成功", isOk:true};
}

function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}