/**
 * 孵化器任务相关逻辑
 * 作者: 李某
 * 任务相关逻辑 包括任务的增删改查 管理后台的任务列表逻辑
 * 
 */

import { TASKTYPEENUM } from "../../config/enum";
import { ERRORENUM } from "../../config/errorEnum";
import { findEnterpriseListByTaskId, updateEnterpriseDraftLock } from "../../data/enterprise/enterprise";
import { findFinancingListByTaskId, updateFinancingDraftLock } from "../../data/enterprise/financing";
import { findmonthTableByTaskId, findmonthTableListByTaskId } from "../../data/fuHuaQi/monthTable";
import { createTaskData, findFuHuaQiTaskByKeyAndUscc } from "../../data/fuHuaQi/task";
import { BizError } from "../../util/bizError";
import { getTaskId, getTimeKey } from "../../util/tools";


/**
 * 获取孵化器的任务列表
 * @param uscc 孵化器的信用标识
 * @returns 
 */
export async function fuHuaQiTaskList(uscc:string) {
    /**
     * 返回格式  [{type:1, title:'', enterpriseList:[] }]
     */
    let result = [];

    const TimeKey = getTimeKey();
    let taskMap = await findFuHuaQiTaskByKeyAndUscc(uscc, TimeKey);

    let taskTypeMapConf = {};
    for (let key in TASKTYPEENUM) {
        let k:any = key;
        if (isNaN(k)) taskTypeMapConf[TASKTYPEENUM[key]] = key;
    }
    const TaskId = getTaskId(uscc);

    for (let typeStr in taskTypeMapConf) {
        let typeKey = parseInt(typeStr);
        let onceObj = { key:typeStr, title:taskTypeMapConf[typeStr], enterpriseList:[]};

        if (!taskMap[typeStr]) { //没有提交任务
            let dataList = [];

            switch(typeKey) {
                case TASKTYPEENUM.孵化器月度填报: dataList = await findmonthTableListByTaskId(TaskId); break;
                case TASKTYPEENUM.新注册或迁入企业登记: dataList = await findEnterpriseListByTaskId(TaskId); break;
                case TASKTYPEENUM.融资企业填报: dataList = await findFinancingListByTaskId(TaskId); break;
            }
           
            dataList.forEach(info => {
                onceObj.enterpriseList.push(info.name);
            });
        }
        result.push(onceObj);
    }

    return result;
}
/**
 * 提交任务
 * @param uscc 孵化器的信用标识
 * @param taskType 任务类型
 */
export async function checkTask(uscc:string, taskType:number) {
    const TimeKey = getTimeKey();
    const TaskId = getTaskId(uscc);
    let taskMap = await findFuHuaQiTaskByKeyAndUscc(uscc, TimeKey);

    if ( taskMap[taskType] ) throw new BizError(ERRORENUM.不能重复提交任务, uscc, taskType);

    switch (taskType) {
        case TASKTYPEENUM.孵化器月度填报:
            let tableInfo = await findmonthTableListByTaskId(TaskId);
            if (!tableInfo) throw new BizError();//todo  没有做弹框
            if (tableInfo.draftLock ) throw new BizError(ERRORENUM.不能重复提交任务, uscc, taskType, 'lock = true');
            tableInfo.draftLock = true;
            await tableInfo.save();
        break;
        case TASKTYPEENUM.新注册或迁入企业登记:
            await updateFinancingDraftLock(TaskId);
        break;
        case TASKTYPEENUM.融资企业填报:
            await updateEnterpriseDraftLock(TaskId);
        break;
    }

    //添加一条任务
    await createTaskData(uscc, TimeKey, TaskId, taskType);

    return {isSuccess:true};
}
