/**
 * 系统中使用的工具
 * 包括 任务生成规则
 * 包括 key生成规则
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");

const md5 = require("md5");


/**
 * 生成任务id
 * @param uscc 企业标识
 * @returns 
 */
export function getTaskId(uscc:string) {
    // return `${uscc}${getTimeKey()}`;
    //todo 这里15号要改掉
    return `${uscc}${20232}`;
}


/**
 * 根据时间生成任务id
 * @param uscc 企业标识
 * @param timeMs 时间戳
 * @returns 
 */
export function getTaskIdByTime(uscc:string, timeMs:number) {
    return `${uscc}${new Date(timeMs).getFullYear()}${new Date(timeMs).getMonth() + 1 }`;
}


/**
 * 获取当前日期的key
 * @param timeMs 指定时间，如果不传
 * @returns 
 */
export function getTimeKey(timeMs?) {
    if (timeMs) return `${new Date(timeMs).getFullYear()}${new Date(timeMs).getMonth() + 1 }`;
    return `${new Date().getFullYear()}${new Date().getMonth() + 1 }`;
}


/**
 * 获取上一月的日期的key
 * @returns 
 */
export function getLastTimeKey() {
    return moment().subtract(1,'months').format('YYYYM');
}


/**
 * 生成草稿箱Id
 * @param uscc 
 * @returns 
 */
export function getDraftId(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random()*1000)}`);
}


/**
 * 密码加密
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns md5后的密码
 */
export function getPwdMd5(uscc:string, pwd:string) {
    return md5(uscc+pwd);
}


/**
 * md5加密
 * @param pwd 
 * @returns pwd 加密后密码
 */
export function md5PwdStr(pwd:string) {
    return md5(pwd);
}

/**
 * 获取token
 * @param uscc 统一信用代码
 */
export function getToken(uscc:string) {
    return md5(`${uscc}${new Date().valueOf()}${Math.ceil(Math.random() *100)}`);
}


/**
 * 校验uscc是否合法
 * @param uscc 
 * @returns true/false 
 */
export function eccUscc(uscc:string) {
    let isSuccess = false;
    if (uscc.search(/^[A-Za-z0-9]{16}$/) > -1) isSuccess = true;
    else if (uscc.search(/^[A-Za-z0-9]{18}$/) > -1) isSuccess = true;
    return isSuccess;
}