/**
 * 管理后台端 企业相关 
 * 包括 在孵企业页面
 * 包括 企业融资页面 
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseAdminBiz from '../../biz/admin/enterprise/enterprise';
import * as financingAdminBiz from '../../biz/admin/enterprise/financing';
import { getTimeKey } from '../../tools/system';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/enterprise/list',checkGuanWeiHuiToken, asyncHandler(getEnterpriseList));
    httpServer.post('/admin/enterprise/financinglist',checkGuanWeiHuiToken, asyncHandler(getFinancingList));
    httpServer.post('/admin/enterprise/affiliationfuhuaqi',checkGuanWeiHuiToken,asyncHandler(affiliationFuHuaQi));
    httpServer.post('/admin/data/output/enterprise',checkGuanWeiHuiToken, asyncHandler(outPutEnterpriseData));
    httpServer.post('/admin/data/output/financing',checkGuanWeiHuiToken, asyncHandler(outPutFinancingData));
}


/**
 * 后台管理 获取在孵企业信息列表 
 * @param req 
 * @param res 
 */
async function getEnterpriseList(req, res) {
    let reqConf = {createType: 'Number', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', page: 'Number' };
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry", "isNaturalPersonHolding" ];
    let { createType, fuHuaQiUscc, industry, isNaturalPersonHolding, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await enterpriseAdminBiz.enterpriseList(createType, fuHuaQiUscc, industry, isNaturalPersonHolding, page);
    res.success(result);
}


/**
 * 后台管理 获取融资企业信息列表 
 * @param req 
 * @param res
 */
async function getFinancingList(req, res) {
    let reqConf = {monthData: 'String', fuHuaQiName: 'String', fuHuaQiInvestment: 'Number', industry: '[Number]', page: 'Number' };
    const NotMustHaveKeys = ["monthData", "fuHuaQiName", "fuHuaQiInvestment", "industry" ];
    let {monthData, fuHuaQiName, industry, fuHuaQiInvestment, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await financingAdminBiz.financingList(monthData, fuHuaQiName, industry, fuHuaQiInvestment, page);
    res.success(result);
}


/**
 * 所属孵化器
 * 下拉框
 * @param req 
 * @param res 
 */
async function affiliationFuHuaQi(req, res) {
    let  result = await enterpriseAdminBiz.getAffiliationFuHuaQi();
    res.success(result);
}


/**
 * 导出在孵企业数据
 * @param req 
 * @param res 
 */
async function outPutEnterpriseData(req, res) {
    let reqConf = {createType: 'Number', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', type:'Number' };
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry", "isNaturalPersonHolding" ];
    let { createType, fuHuaQiUscc, industry, isNaturalPersonHolding, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    
    let dataList = await enterpriseAdminBiz.outPutEnterpriseData(createType, fuHuaQiUscc, industry, isNaturalPersonHolding, type);

    let name = `在孵企业${getTimeKey()}.xlsx`;

    res.success({name, data:dataList});
}


/**
 * 导出企业融资数据
 * @param req 
 * @param res 
 */
async function outPutFinancingData(req, res) {
    let reqConf = {monthData: 'String', fuHuaQiName: 'String', fuHuaQiInvestment: 'Number', industry: '[Number]', type:'Number' };
    const NotMustHaveKeys = ["monthData", "fuHuaQiName", "fuHuaQiInvestment", "industry" ];
    let {monthData, fuHuaQiName, industry, fuHuaQiInvestment, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let dataList =  await financingAdminBiz.outPutFinancingList(monthData, fuHuaQiName, industry, fuHuaQiInvestment, type);

    let name = `融资企业${getTimeKey()}.xlsx`;

    res.success({name, data:dataList});
}
