/**
 * 企业投资信息表
 * draftLock 草稿锁 当任务提交的时候，将此字段改为true
 * 一个企业在一个月只能录入一个融资数据 2023-02-07 确定此需求
 */

import { mySqlTableClass } from "../../db/mysql/mysqlClass";

/**表结构 */
const TableConfig = {
    uscc:"string",//融资企业统一信用代码 冗余字段
    fuHuaQiUscc:"string",//孵化器统一信用代码 冗余字段
    name:"string",//企业名称
    taskId:"string", //任务id
    logonAdd:"string",//注册地址
    operatingAdd:"string",//经营地址
    financingAmount:"number",//融资金额(万元)
    investmentInstitutionsName:"string",//投资机构名称
    timeToObtainInvestment:"date",//获得投资时间
    fuHuaQiInvestment:"boolean", //孵化器是否投资
    fuHuaQiInvestmentAmount:"number",//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:"number",//孵化器投资方式
    draftLock:"boolean", //草稿锁，true为提交之后，false为草稿
    createTime:"date",//录入时间
    industry:"string",//领域
}

/**sql */
enum SQLENUM {

}
/**多表sql */
enum MORETABLESQLENUM {

}

let financingModel;

export function initModel() {
    financingModel = new mySqlTableClass("financing", TableConfig, SQLENUM, MORETABLESQLENUM);
}
