
export enum ERRORENUM {
    未找到数据,
    参数错误,
    不能重复提交任务,
    表单校验失败,
    该企业已存在,
    数据无更新,
    该孵化器月度填报已存在,
    该企业当月数据已存在,
    该报表需要填写本月内容后提交,
    密码错误,
    密码不允许有特殊字符,
    不能重复修改密码,
    身份验证失败,
    非法登录,
    身份验证过期,
    密码长度不能超过24个字符,
    账号不存在,
    已入库的数据不能删除,
    任务不存在,
    该企业不存在,
    该孵化器账号信息已存在,
    密码不一致,
    密码只能由6至18位字符和数字组成,
    统一社会信用代码不合法,
    统一社会信用代码重复,
    系统错误,
    该任务已提交,
    无法操作其他孵化器的企业,
    请填入其他原因,
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}