/**内部开放接口 */

import * as monthTableData from "../../data/fuHuaQi/monthTable";
import * as taskData from "../../data/fuHuaQi/task";
import * as enterpriseData from "../../data/enterprise/enterprise";
import { FUHUASTATE, TASKTYPEENUM } from "../../config/enum";
import { ERRORENUM } from "../../config/errorEnum";
import { findAllNotDisabledFuHuaQi } from "../../data/fuHuaQi/fuhuaqi";
import { BizError } from "../../util/bizError";
import { logHandle } from "../../util/log";



/**
 * 发放1月数据
 */
export async function provideLastTask() {
    const TimeKey = '20232';

    let addList = [];//任务列表
    let monthList = [];//月度填报列表
    
    const MonthNumber = 1;//数据填报月份
    const YearNumber = 2023
    const MonthTableName = `${MonthNumber}月孵化器月度填报`;

    let fuHuaQiList = await findAllNotDisabledFuHuaQi();
    fuHuaQiList.forEach(info => {
        let { uscc } = info;
        let taskId = `${uscc}${TimeKey}`;
        addList.push( { key:TimeKey, type:TASKTYPEENUM.孵化器月度填报, month:1, taskId, fuHuaQiUscc:uscc, isSubmit:false},
            { key:TimeKey, type:TASKTYPEENUM.新注册或迁入企业登记, month:1, taskId, fuHuaQiUscc:uscc, isSubmit:false },
            { key:TimeKey, type:TASKTYPEENUM.融资企业填报, month:1, taskId, fuHuaQiUscc:uscc, isSubmit:false});
        /**任务报表的初始状态为 草稿(draftLock=fals) 未被编辑(isUpdate=false)  */
        monthList.push({ taskId, name:MonthTableName, fuHuaQiUscc:uscc, month:MonthNumber, year:YearNumber, draftLock:false, isUpdate:false });
    });

    try {
        /**初始化 任务 */
        await taskData.createTaskToList(addList);
        logHandle(`添加了${addList.length} 任务`);
         /**初始化 月度填报表 */
        await monthTableData.createMonthTableToList(monthList);
        logHandle(`添加了${monthList.length} 月度任务`);
    } catch (err) {
        new BizError(ERRORENUM.系统错误, '添加任务和月度报表的时候 出现了异常 请检查数据库  ', err);
    }
}


export async function updateEnterpriseFuHuaState() {
    await enterpriseData.updateEnterpriseState(FUHUASTATE.实体孵化);
    return {};
}