/**
 * 用作前端埋点的接口
 * 埋点中的登录埋点为 模拟登录埋点  埋点的规则是  进入首页并且不是二级页面返回  （这里要前端判断用户行为）
 */


import * as asyncHandler from 'express-async-handler';
import { checkEnterpriseToken, checkFuHuaQiToken} from '../middleware/user';
import { addPoint } from '../biz/point';
import { FUHUAQINODEENUM, POINTTYPEENUM } from '../config/pointConfig';


export function setRouter(httpServer) {
    /** 孵化器端 */
    httpServer.post('/point/fuhuaqi/open', checkFuHuaQiToken, asyncHandler(fuHuaQiLoginPoint) );
    
    /**企业端 */
    httpServer.post('/point/enterprise/open', checkEnterpriseToken, asyncHandler(enterpriseLoginPoint) );
}


/**
 * 孵化器登录埋点
 * @param req 
 * @param res 
 */
async function fuHuaQiLoginPoint(req, res) {
    const Uscc = req.headers.uscc;
    addPoint(POINTTYPEENUM.孵化器, Uscc, FUHUAQINODEENUM.进入首页, null);
    res.success({isSuccess:true});
}


/**
 * 企业登录埋点
 * @param req 
 * @param res 
 */
async function enterpriseLoginPoint(req, res) {
    const Uscc = req.headers.uscc;
    addPoint(POINTTYPEENUM.孵化器, Uscc, FUHUAQINODEENUM.进入首页, null);
    res.success({isSuccess:true});
}
