/**
 * 小程序端  企业入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import { checkEnterpriseToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as enterpriseBiz from '../../biz/mobileEnterprise/base/enterprise';
import * as initialTeamsBiz from '../../biz/mobileEnterprise/base/initialTeams';
import * as intellectualPropertyBiz from '../../biz/mobileEnterprise/base/intellectualProperty';
import * as qualificationBiz from '../../biz/mobileEnterprise/base/qualification';
import * as dataDeclarationBiz from '../../biz/mobileEnterprise/quarterTask/dataDeclaration';
import * as policyBiz from '../../biz/mobileEnterprise/policy';


export function setRouter(httpServer) {
    /**首页 */
    httpServer.post('/enterprise/base/headeinfo', checkEnterpriseToken, asyncHandler(homePageHeaderInfo));
    /**基本信息 */
    httpServer.post('/enterprise/base/info', checkEnterpriseToken, asyncHandler(baseInfo));
    httpServer.post('/enterprise/base/update', checkEnterpriseToken, asyncHandler(updateBaseInfo));
    /**创始团队 */
    httpServer.post('/enterprise/initialteam/update', checkEnterpriseToken, asyncHandler(updateTeamsState));
    httpServer.post('/enterprise/initialteam/info', checkEnterpriseToken, asyncHandler(initialTeamInfo));
    /**知识产权 */
    httpServer.post('/enterprise/intellectualproperty/update', checkEnterpriseToken, asyncHandler(updateIntellectualproperty));
    httpServer.post('/enterprise/intellectualproperty/info', checkEnterpriseToken, asyncHandler(intellectualpropertyInfo));
    /**企业资质 */
    httpServer.post('/enterprise/qualification/update', checkEnterpriseToken, asyncHandler(updateQualification));
    httpServer.post('/enterprise/qualification/info', checkEnterpriseToken, asyncHandler(qualificationInfo));
    /**资讯 */
    httpServer.post('/enterprise/information/list', checkEnterpriseToken, asyncHandler(informationList));
    httpServer.post('/enterprise/information/outofdate', checkEnterpriseToken, asyncHandler(outOfDateInformationList));
    httpServer.post('/enterprise/information/info', checkEnterpriseToken, asyncHandler(onceInformationData));
    httpServer.post('/enterprise/information/titlelist', checkEnterpriseToken, asyncHandler(informationTitleListData));
    /**团队信息 */
    httpServer.post('/enterprise/team/info', checkEnterpriseToken, asyncHandler(showTeamInfomation));
    /**创业创新方向 */
    httpServer.post('/enterprise/cycxfx/update', checkEnterpriseToken, asyncHandler(cycxfxUpdate));
    httpServer.post('/enterprise/cycxfx/select', checkEnterpriseToken, asyncHandler(cycxfxSelect));
    /**创业创始人背景 */
    httpServer.post('/enterprise/cycsrbj/update', checkEnterpriseToken, asyncHandler(cycsrbjUpdate));
    httpServer.post('/enterprise/cycsrbj/select', checkEnterpriseToken, asyncHandler(cycsrbjSelect));
}


/**
 * 首页数据 顶部信息
 * @param req 
 * @param res 
 */
async function homePageHeaderInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.getHomePageHeaderData(Uscc);
    res.success(result);
}


/**
 * 修改团队状态
 * @param req 
 * @param res 
 */
async function updateTeamsState(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {firstClassTalent:'Number', teams:'[Object]'};
    let {firstClassTalent, teams} = eccReqParamater(reqConf, req.body, ["teams"]);
    
    let result = await initialTeamsBiz.updateInitialTeamInfo(Uscc, firstClassTalent, teams);

    res.success(result);
}


/**
 * 创始团队信息
 * @param req 
 * @param res 
 */
async function initialTeamInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await initialTeamsBiz.selectInitialTeamInfo(Uscc);

    res.success(result);
}


/**
 * 修改知识产权信息
 * @param req 
 * @param res 
 */
async function updateIntellectualproperty(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {alienPatent:'Number', classIPatent:'Number', secondClassPatent:'Number'};
    let {alienPatent, classIPatent, secondClassPatent} = eccReqParamater(reqConf, req.body);

    let result = await intellectualPropertyBiz.updateIntellectualProperty(Uscc, alienPatent, classIPatent, secondClassPatent);

    res.success(result);
}


/**
 * 查询知识产权信息
 * @param req 
 * @param res 
 */
async function intellectualpropertyInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await intellectualPropertyBiz.selectIntellectualProperty(Uscc);

    res.success(result);
}


/**
 * 查询企业资质信息
 * @param req 
 * @param res 
 */
async function qualificationInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await qualificationBiz.selectQualification(Uscc);

    res.success(result);
}

/**
 * 修改知识产权信息
 * @param req 
 * @param res 
 */
async function updateQualification(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let {form} = eccReqParamater(reqConf, req.body);

    let result = await qualificationBiz.updateQualification(Uscc, form);

    res.success(result);
}


/**
 * 修改企业基本信息
 * @param req 
 * @param res 
 */
async function updateBaseInfo(req, res) {
    const Uscc = req.headers.uscc;

    let reqConf = {form:'Object'};
    let {form} = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.updateEnterpriseBaseInfo(Uscc, form);

    res.success(result);
}

/**
 * 查询企业基本信息
 * @param req 
 * @param res 
 */
async function baseInfo(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.enterpriseBaseInfo(Uscc);

    res.success(result);
}


/**
 * 点击查看团队信息数据
 * @param req 
 * @param res 
 */
async function showTeamInfomation(req, res) {
    const Uscc = req.headers.uscc;
    let result = await dataDeclarationBiz.showTeamInfo(Uscc );
    res.success(result);
}


/**
 * 政策列表
 * @param req 
 * @param res 
 */
async function informationList(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {selectTitle:'String', page:'Number'};
    let {selectTitle, page} = eccReqParamater(reqConf, req.body, ["selectTitle"]);
    let result = await policyBiz.getInformationList(Uscc, selectTitle, page);
    res.success(result);
}


/**
 * 往期政策列表
 * @param req 
 * @param res 
 */
async function outOfDateInformationList(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {selectTitle:'String', page:'Number'};
    let {selectTitle, page} = eccReqParamater(reqConf, req.body, ["selectTitle"]);
    let result = await policyBiz.getInformationList(Uscc, selectTitle, page);
    res.success(result);
}


/**
 * 政策详情
 * @param req 
 * @param res 
 */
async function onceInformationData(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {id:'String'};
    let {id} = eccReqParamater(reqConf, req.body);
    let result = await policyBiz.getOnceinformation(Uscc, id);
    res.success(result);
}


/**
 * 首页政策列表
 * @param req 
 * @param res 
 */
async function informationTitleListData(req, res) {
    let result = await policyBiz.getInformationTitleList();
    res.success(result);
}


/**
 * 创业创新方向修改
 * @param req 
 * @param res 
 */
async function cycxfxUpdate(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {cycxfx:'[Number]'};
    let {cycxfx} = eccReqParamater(reqConf, req.body);
    let result = await enterpriseBiz.updateCYCXFX(Uscc, cycxfx);
    res.success(result);
}


/**
 * 查询创业创新方向
 * @param req 
 * @param res 
 */
async function cycxfxSelect(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.selectCYCXFX(Uscc);
    res.success(result);
}


/**
 * 创业创始人背景修改
 * @param req 
 * @param res 
 */
async function cycsrbjUpdate(req, res) {
    const Uscc = req.headers.uscc;
    let reqConf = {cycsrbj:'[Number]'};
    let {cycsrbj} = eccReqParamater(reqConf, req.body);
    let result = await enterpriseBiz.updateCYCSRBJ(Uscc, cycsrbj);
    res.success(result);
}


/**
 * 查询创业创始人背景
 * @param req 
 * @param res 
 */
async function cycsrbjSelect(req, res) {
    const Uscc = req.headers.uscc;
    let result = await enterpriseBiz.selectCYCSRBJ(Uscc);
    res.success(result);
}

