/**
 * 分数路由
 */

import * as asyncHandler from 'express-async-handler';
import * as fuHuaQiAdminBiz from '../../biz/admin/fuHuaQi/fuHuaQi';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/score/ranklist',checkGuanWeiHuiToken, asyncHandler(fuHuaQiScoreList));
    httpServer.post('/admin/data/output/score',checkGuanWeiHuiToken, asyncHandler(outPutList));
}


/**
 * 孵化器排名
 * @param req 
 * @param res 
 */
async function fuHuaQiScoreList(req, res) {
    let reqConf = {
        time: 'Number', //时间
        name: 'String',//机构名称
        page: 'Number' 
    };
    const NotMustHaveKeys = ["time", "name"];
    let {time, name, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await fuHuaQiAdminBiz.fuHuaQiScore(time, name, page);

    res.success(result);
}


/**
 * 导出孵化器排名
 * @param req 
 * @param res 
 */
async function outPutList(req, res) {
    let reqConf = {
        time: 'Number', //时间
    };
    const NotMustHaveKeys = ["time"];
    let {time } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let {outPutList, outPutName} = await fuHuaQiAdminBiz.outPutFuHuaQiScore(time);
    let name = `孵化器${outPutName}排名.xlsx`;

    res.success({name, data:outPutList});
}
