/**
 * 管理后台端 机构资质
 */

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as instituQualifyBiz  from '../../biz/admin/fuHuaQi/instituQualify';


export function setRouter(httpServer) {
    /**3.1新加 */
    httpServer.post('/admin/fuhuaqi/instituqualify/i18n/registered',checkGuanWeiHuiToken, asyncHandler(i18nRegister));
    httpServer.post('/admin/fuhuaqi/instituqualify/i18n/unregistered',checkGuanWeiHuiToken, asyncHandler(i18nUnRegister));
    httpServer.post('/admin/fuhuaqi/instituqualify/icr',checkGuanWeiHuiToken, asyncHandler(icr));
    httpServer.post('/admin/fuhuaqi/instituqualify/startupteacher',checkGuanWeiHuiToken, asyncHandler(startupTeacher));
    httpServer.post('/admin/fuhuaqi/instituqualify/zjbeyondlayout',checkGuanWeiHuiToken, asyncHandler(zjBeyondLayout));
    httpServer.post('/admin/fuhuaqi/instituqualify/ptp',checkGuanWeiHuiToken, asyncHandler(ptp));
    httpServer.post('/admin/fuhuaqi/instituqualify/professionaltechnology',checkGuanWeiHuiToken, asyncHandler(professionalTechnology));

    httpServer.post('/admin/data/output/i18nregistered',checkGuanWeiHuiToken, asyncHandler(outputI18nRegister));
    httpServer.post('/admin/data/output/i18nunregistered',checkGuanWeiHuiToken, asyncHandler(outputI18nUnRegister));
    httpServer.post('/admin/data/output/icr',checkGuanWeiHuiToken, asyncHandler(outputIcr));
    httpServer.post('/admin/data/output/startupteacher',checkGuanWeiHuiToken, asyncHandler(outputStartupTeacher));
    httpServer.post('/admin/data/output/zjbeyondlayout',checkGuanWeiHuiToken, asyncHandler(outputZjBeyondLayout));
    httpServer.post('/admin/data/output/ptp',checkGuanWeiHuiToken, asyncHandler(outputPtp));
    httpServer.post('/admin/data/output/professionaltechnology',checkGuanWeiHuiToken, asyncHandler(outputProfessionalTechnology));
    
}


/**
 * 国际化 已登记 列表
 * @param req 
 * @param res 
 */
async function i18nRegister(req, res) {
     let reqConf = {
        name:'String',
        page:'Number'  
    };
    const NotMustHaveKeys = ["name"];
    let {name, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.getI18nRegisterDataList(name, page);

    res.success(result);
}

/**
 * 国际化 已登记 导出
 * @param req 
 * @param res 
 */
async function outputI18nRegister(req, res) {
    let reqConf = {
       name:'String',
       type:'Number'  
   };
   const NotMustHaveKeys = ["name"];
   let {name, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let result = await instituQualifyBiz.outPutI18nRegisterData(name, type);

   let fileName = `已登记国际化-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}

/**
 * 国际化 未登记 列表
 * @param req 
 * @param res 
 */
async function i18nUnRegister(req, res) {
    let reqConf = {
       name:'String',
       page:'Number'  
   };
   const NotMustHaveKeys = ["name"];
   let {name, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let result = await instituQualifyBiz.getI18nNotRegisterDataList(name, page);

   res.success(result);
}

/**
 * 国际化 未登记 导出
 * @param req 
 * @param res 
 */
async function outputI18nUnRegister(req, res) {
    let reqConf = {
       name:'String',
       type:'Number'  
   };
   const NotMustHaveKeys = ["name"];
   let {name, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let result = await instituQualifyBiz.outPutI18nNotRegisterData(name, type);

   let fileName = `未登记国际化-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}

/**
 * 
 * @param req 
 * @param res 
 */
async function icr(req, res) {
     let reqConf = {
        name:'String',
        cMode:'Number',
        page:'Number'
    };
    const NotMustHaveKeys = ["name", "cMode"];
    let {cMode, name, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.getIcrDataList(name, cMode, page);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function outputIcr(req, res) {
    let reqConf = {
       name:'String',
       cMode:'Number',
       type:'Number'
   };
   const NotMustHaveKeys = ["name", "cMode"];
   let {cMode, name, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let result = await instituQualifyBiz.outputIcrDataList(name, cMode, type);

   let fileName = `大学科研院所合作机构-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}


/**
 * 
 * @param req 
 * @param res 
 */
async function startupTeacher(req, res) {
     let reqConf = {
        name:'String',
        speciality: 'Number', 
        teacherLv:'Number',
        page: 'Number' 
    };
    const NotMustHaveKeys = ["name", "speciality", "teacherLv"];
    let {name, speciality, teacherLv, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.getStartupTeacherDataList(name, speciality, teacherLv, page);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function outputStartupTeacher(req, res) {
    let reqConf = {
       name:'String',
       speciality: 'Number', 
       teacherLv:'Number',
       type: 'Number' 
   };
   const NotMustHaveKeys = ["name", "speciality", "teacherLv"];
   let {name, speciality, teacherLv, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let result = await instituQualifyBiz.outputStartupTeacherDataList(name, speciality, teacherLv, type);

   let fileName = `创业导师-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}

/**
 * 
 * @param req 
 * @param res 
 */
async function zjBeyondLayout(req, res) {
    let reqConf = {
        name:'String',
        operationMode:"Number",//运营模式
        page:'Number'
    };
    const NotMustHaveKeys = ["name", "operationMode"];
    let {name, operationMode, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.getZJBeyondLayoutDataList(name, operationMode, page);

    res.success(result);
}

/**
 * 
 * @param req 
 * @param res 
 */
async function outputZjBeyondLayout(req, res) {
    let reqConf = {
        name:'String',
        operationMode:"Number",//运营模式
        type:'Number'
    };
   const NotMustHaveKeys = ["name", "operationMode"];
   let {name, operationMode, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
   let result = await instituQualifyBiz.outputZJBeyondLayoutDataList(name, operationMode, type);

   let fileName = `张江以外布局-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}


/**
 * 
 * @param req 
 * @param res 
 */
async function ptp(req, res) {
    let reqConf = {
        name:'String',
        isCreatePTP:"Number",//是否创立
        isParticipateInPTP:"Number",//是否参与 1 是全部 2 是  3否
        page:'Number'
    };
    const NotMustHaveKeys = ["name", "isCreatePTP", "isParticipateInPTP"];
    let {name, isCreatePTP, isParticipateInPTP, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.getPTPDataList(name, isCreatePTP, isParticipateInPTP, page);

    res.success(result);
}


/**
 * 
 * @param req 
 * @param res 
 */
async function outputPtp(req, res) {
    let reqConf = {
        name:'String',
        isCreatePTP:"Number",//是否创立
        isParticipateInPTP:"Number",//是否参与 0 是全部 1 是  2否
        type:'Number'
    };
    const NotMustHaveKeys = ["name", "isCreatePTP", "isParticipateInPTP"];
    let {name, isCreatePTP, isParticipateInPTP, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.outputPTPDataList(name, isCreatePTP, isParticipateInPTP, type);

    let fileName = `创投基金-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}


async function professionalTechnology(req, res) {
    let reqConf = {
        name:'String',
        isProfessionalTechnology:"Number",//是否搭建专业技术平台
        year:"Number",//建立时间
        page:"Number"
    };
    const NotMustHaveKeys = ["name", "isCreatePTP", "year"];
    let {name, isProfessionalTechnology, year, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.getProfessionalTechnologyDataList(name, isProfessionalTechnology, year, page);

    res.success(result);
}

async function outputProfessionalTechnology(req, res) {
    let reqConf = {
        name:'String',
        isProfessionalTechnology:"Number",//是否搭建专业技术平台
        year:"Number",//建立时间
        type:"Number"
    };
    const NotMustHaveKeys = ["name", "isCreatePTP", "year"];
    let {name, isProfessionalTechnology, year, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let result = await instituQualifyBiz.outputProfessionalTechnologyDataList(name, isProfessionalTechnology, year, type);

    let fileName = `专业技术平台-${result.name}.xlsx`;
   res.success({name:fileName, data:result.dataList});
}
