/**
 * 管理后台端 数据维护相关
 * 
 */

import * as asyncHandler from 'express-async-handler';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import * as dataMaintenanceBiz from '../../biz/admin/dataMaintenance';


export function setRouter(httpServer) {
    /**企业迁出 */
    httpServer.post('/admin/datamainteance/enterprise/output/list',checkGuanWeiHuiToken, asyncHandler(enterpriseOutputList));
    httpServer.post('/admin/datamainteance/enterprise/output/update',checkGuanWeiHuiToken, asyncHandler(upateEnterpriseOutput));
    /**经营数据 */
    httpServer.post('/admin/datamainteance/enterprise/business/list',checkGuanWeiHuiToken, asyncHandler(enterpriseBusinessList));
    httpServer.post('/admin/datamainteance/enterprise/business/update',checkGuanWeiHuiToken, asyncHandler(updateEnterpriseBusiness));
    /**企业密码维护 */
    httpServer.post('/admin/datamainteance/enterprise/pwd/list',checkGuanWeiHuiToken, asyncHandler(enterprisePwdList));
    httpServer.post('/admin/datamainteance/enterprise/pwd/reset',checkGuanWeiHuiToken, asyncHandler(resetEnterprisePwd));
}


/**
 * 迁出企业功能的企业列表
 * @param req 
 * @param res 
 */
async function enterpriseOutputList(req, res) {
    let reqConf = {fuHuaQiUscc:'String', page: 'Number', enterpriseName: 'String' };
    const NotMustHaveKeys = ["enterpriseName"];
   
    let { fuHuaQiUscc, enterpriseName, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await dataMaintenanceBiz.getEnterpriseListToOutputEnterprise(fuHuaQiUscc, enterpriseName, page);

    res.success(result);
}


/**
 * 批量迁出企业
 * @param req 
 * @param res 
 */
async function upateEnterpriseOutput(req, res) {
    let reqConf = {enterpriseList:'[Object]'};
    const NotMustHaveKeys = [];
   
    let { enterpriseList } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    const userId = req.headers.userid;

    let result = await dataMaintenanceBiz.outputEnterpriseByList(userId, enterpriseList);

    res.success(result);
}


/**
 * 获取企业经营数据列表
 * @param req 
 * @param res 
 */
async function enterpriseBusinessList(req, res) {
    let reqConf = {fuHuaQiUscc:"String", year:"Number", quarter:"Number", type:"Number", enterpriseName:"String", page:"Number"};
    const NotMustHaveKeys = ["enterpriseName"];
   
    let { fuHuaQiUscc, year, quarter, type, enterpriseName, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await dataMaintenanceBiz.enterpriseBusinessDataList(fuHuaQiUscc, year, quarter, type, enterpriseName, page);

    res.success(result);
}


/**
 * 修改企业经营数据
 * @param req 
 * @param res 
 */
async function updateEnterpriseBusiness(req, res) {
    let reqConf = {uscc:"String", RD:"Number", TXP:"Number", BI:"Number", year:"Number", quarter:"Number", type:"Number"};
    const NotMustHaveKeys = ["RD", "TXP", "BI"];
   
    let { uscc, RD, TXP, BI, year, quarter, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    const userId = req.headers.userid;

    let result = await dataMaintenanceBiz.updateEnterpriseBusinessData(userId, uscc, RD, TXP, BI, year, quarter, type);

    res.success(result);
}


/**
 * 通过uscc查询企业信息  用于重置密码
 * @param req 
 * @param res 
 */
async function enterprisePwdList(req, res) {
    let reqConf = {uscc:"String"};
    const NotMustHaveKeys = [];
   
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await dataMaintenanceBiz.getEnterprisePwdList(uscc);

    res.success(result);
}


/**
 * 重置企业密码
 * @param req 
 * @param res 
 */
async function resetEnterprisePwd(req, res) {
    let reqConf = {uscc:"String"};
    const NotMustHaveKeys = [];
    const userId = req.headers.userid;
    let { uscc } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await dataMaintenanceBiz.resettingEnterprisePwd(userId, uscc);

    res.success(result);
}


