
import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';

const dataMaintenanceLogSchema = new Schema({
    t:{type:Number, index:true },//操作类型 全名nodeType
    u: {type:String, index:true},//用户
    ms:Number,//操作时间
    info:String//操作明细
});

var dataMaintenanceLogModel;
export function initModel(){
    dataMaintenanceLogModel = baseDB.model('dataMaintenanceLog', dataMaintenanceLogSchema);
}


/**
 * 添加数据维护操作日志
 * @param t 
 * @param u 
 * @param info 
 */
export async function addDataMaintenanceLog(t:number, u:string, info:string) {
    await dataMaintenanceLogModel.create({t, u, info, ms:new Date().valueOf() });
}


