/**
 * 孵化器信息表
 * operationName不可修改 2023-02-06 确定此需求
 * uscc不可修改 2023-02-06 确定此需求
 * 首次登录要求改密码 不改密码不能继续操作 2023-02-07 确定此需求
 * 管理后台列表页面一页展示10条 2023-02-08 确定此需求
 * 孵化器账号不能被删除 只能被禁用 2023-02-08 确定此需求
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';

const foundingTeamSchema = new Schema({
    memberName:String,//成员姓名
    memberSex:Number,//成员性别
    memberAge:Number,//成员年龄
    memberDEGREE:Number,//成员最高学历
    memberSchool:String,//毕业学校
    des:String,//履历描述
},{_id:false});

/**经备案场地地址 */
const hatchingGroundSchema = new Schema({
    //personInChargeAdd:String,//孵化场地地址
    siteAcreage:Number,//孵化场地面积(㎡)
    leasePrice:Number,//孵化场地出租单价
    /**2.0  后改的地址 */
    personInChargeAddress:{type:[String], default:[]}
},{_id:false});

const fuHuaQiSchema = new Schema({
    name: {type:String,index: true},//名称
    operationName:String,//运营机构名称  不可修改
    uscc:{type:String, index: true},//统一信用代码 也是登录账号 不可修改
    virtualEnterpriseNum:{type:Number, default:0},//虚拟企业数量
    logonTime:Number,//注册时间
    incubatedAcreage:Number,//在孵面积(㎡)
    acreageTotal:Number,//孵化器总面积(㎡)
    acreagePersonalUse:Number,//孵化器自用面积(㎡)
    lv:Number,//孵化器级别
    identificationTime:Number,//认定时间
    industry:[Number],//孵化领域
    institutionalNature:Number,//机构性质
    liaison:String,//联系人
    liaisonPhone:String,//联系电话
    personInCharge:String,//负责人
    personInChargePhone:String,//负责人联系电话
    hatchingGround:{type:[hatchingGroundSchema], default:[] },//经备案孵化场地
    foundingTeam:{type:[foundingTeamSchema], default:[]},//创业团队
    foundingTeamType:{type:Number, default:1},//创业团队类型
    operationModel:{type:[Number], default:[]},//运营模式 
    operationModelDes:String,//运营模式描述
    /** 累计孵化企业数量*/
    fuHuaEnterpriseTotal:{type:Number, default:0},//累计孵化企业数量 初始值
    /**用户相关 */
    pwd:String,//登录密码
    token:{type:String, index:true},
    tokenMs:Number,
    firstLoginIsChangePwd:{type:Boolean, default:false},//首次登录是否修改密码
    createTime:Number,
    userState:{type:Boolean, default:false}, //是否禁用
    /**绑定账号相关 */
    bindDeviceId:String,//绑定时的设备号
    bindId:{type:String},//绑定标识
    /**2.3加入字段 */
    introduction:{type:String, default:""},//孵化器简介
    /**3.1 创投基金相关*/
    isCreatePTP:Number,//是否成立创投基金
    scalePTP:Number,//基金规模
    isParticipateInPTP:Boolean,//是否参与创投基金
    participatingFundCompany:String,//参股基金公司名
    /**专业技术平台 */
    isProfessionalTechnology:Number,//是否专业技术平台
    professionalTechnologyName:String,//专业技术平台名称
    professionalTechnologyCreateTime:Number,//时间  年份 xxxx年01月01日 的时间戳
    professionalTechnologyAmount:Number,//投资金额 万元
    isCooperation:{type:Boolean, default:false},//是否与第三方合作
    cooperationInstitutions:{type:String, default:""},//合作机构名称
});

var fuHuaQiModel;
export function initModel(){
    fuHuaQiModel = baseDB.model('fuhuaqi', fuHuaQiSchema);
    fuHuaQiModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await fuHuaQiModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

/**
 * 通过统一信用代码获取孵化器信息
 * 支持.save方法保存对象修改
 * @param uscc 孵化器统一信用代码
 * @returns {}
 */
export async function findFuHuaQiByUSCC(uscc:string) {
    return await fuHuaQiModel.selectOnceData({uscc});
}

/**
 * 通过孵化器名称获取孵化器信息
 * @param name 孵化器名称
 * @returns {}
 */
export async function findFuHuaQiByName(name:string) {
    return await fuHuaQiModel.findOne({name});
}


/**
 * 通过token获取孵化器信息   弃用
 * 中间件使用
 * @param token token
 * @returns 孵化器信息
 */
export async function findFuHuaQiByToken(token:string) {
    return await fuHuaQiModel.findOne({token}).exec();
}


/**
 * 分页获取符合条件的孵化器列表
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 孵化器列表
 */
export async function findFuHuaQiListByPage(selectParam, skipCount) {
    return await fuHuaQiModel.find(selectParam).skip(skipCount).limit(10);
}

/**
 * 获取符合条件的所有孵化器列表
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 孵化器列表
 */
export async function findFuHuaQiList(selectParam) {
    return await fuHuaQiModel.find(selectParam);
}


/**
 * 获取所有孵化器数量
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
export async function findFuHuaQiCount(selectParam) {
    return await fuHuaQiModel.find(selectParam).countDocuments();
}


/**
 * 获取所有运营机构名称的map
 * @returns map key:统一信用代码 value:运营机构名称
 */
export async function findAllFuHuaQiOperationNameMap() {
    let dataList = await fuHuaQiModel.find({});
    let map = {};
    dataList.forEach(info => {
        map[info.uscc] = info.operationName;
    });
    return map;
}

/**
 * 获取所有运营机构名称的map
 * @returns map key:统一信用代码 value:运营机构名称
 */
export async function findFuHuaQiOperationNameMapByParam(param) {
    let dataList = await fuHuaQiModel.find(param);
    let map = {};
    dataList.forEach(info => {
        map[info.uscc] = info.operationName;
    });
    return map;
}

/**
 * 获取所有运营机构的map
 * @returns map key:运营机构名称 value:uscc
 */
export async function findAllFuHuaQiOperationUsccMap() {
    let dataList = await fuHuaQiModel.find({});
    let map = {};
    dataList.forEach(info => {
        map[info.operationName] = info.uscc;
    });
    return map;
}

/**
 * 聚合查询 孵化器所拥有的企业数量
 * @returns {} key=孵化器统一信用 value=企业数量
 */
 export async function groupFindFuHuaQi() {
    let match = {draftLock:true};//前置条件
    let dataList = await fuHuaQiModel.aggregate([{$match:match},{$group:{_id:"$fuHuaQiUscc",count:{$sum:1}}}]).exec();
    let result = {};
    dataList.forEach(info => {
        let {_id, count} = info;
        result[_id] = count;
    });
    return result;
}


/**
 * 获取所有孵化器
 * @param selectParam 查询参数
 * @param skipCount 跳过数量
 * @returns [] 孵化器列表
 */
 export async function findFuHuaQiUserList(selectParam, skipCount) {
    return await fuHuaQiModel.find(selectParam).skip(skipCount).limit(10);
}

/**
 * 获取所有孵化器
 * @param selectParam 查询参数
 * @returns number 数据数量
 */
 export async function findFuHuaQiUserCount(selectParam) {
    return await fuHuaQiModel.find(selectParam).countDocuments();
}


/**
 * 查询所有非禁用状态下的孵化器
 * 限制返回字段     uscc
 *                  operationName
 * @returns []
 */
export async function findAllNotDisabledFuHuaQi() {
    return await fuHuaQiModel.find({userState:false}, 'uscc operationName');
}


/**
 * 添加孵化器账号 
 * @param param 新增参数
 * @returns 
 */
export async function createFuHuaQiUser(param) {
    return await fuHuaQiModel.create(param);
}


export async function createFuHuaQiToList(fuHuaQiList:object) {
    await fuHuaQiModel.insertMany(fuHuaQiList);
}


/**
 * 根据绑定id查找孵化器列表
 * @param bindId 绑定id
 * @returns {}
 */
export async function findFuHuaQiByBindId(bindId:string) {
    return await fuHuaQiModel.find({bindId});
}


export async function findFuHuaQiFilesDataByParam(param, files) {
    return await fuHuaQiModel.find(param, files);
}