/**
 * 企业创始团队
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';

const initialTeamSchema = new Schema({
    id:{type:String, index:true}, //id标识
    uscc:{type:String, index:true},//企业uscc
    name:String,//企业名称
    type:Number,//创始团队人才类型
    memberName:String,//成员姓名
    memberSex:Number,//成员性别
    memberAge:Number,//成员年龄  出生年月时间戳
    memberDEGREE:Number,//成员最高学历
    memberSchool:String,//毕业学校
    des:String,//履历描述
},{_id:false});


var initialTeamModel;
export function initModel(){
    initialTeamModel = baseDB.model('enterpriseInitialTeam', initialTeamSchema);
}


/**
 * 添加团队成员
 * @param uscc 
 * @param name 
 * @param teamList 
 */
export async function addEnterpriseInitialTeam(teamInfo ) {
    return await initialTeamModel.create(teamInfo);
}

export async function findEnterpriseInitialTeam(uscc:string) {
    return await initialTeamModel.find({uscc});
}

export async function deleteEnterpriseInitialTeamMember(id:string) {
    await initialTeamModel.deleteOne({id});
}

export async function addMoneyEnterpriseInitialTeam(teams) {
    await initialTeamModel.insertMany(teams);
}

export async function updateMoneyEnterpriseInitialTeam(updateTeams) {
    for (let i = 0; i < updateTeams.length; i++) {
        let info = updateTeams[i];
        let id = info.id;
        delete info.id;
        await initialTeamModel.updateOne({id}, info );
    }
}

export async function deleteMoneyEnterpriseInitialTeam(deleteTeams) {
    for (let i = 0; i < deleteTeams.length; i++) {
        let info = deleteTeams[i];
        let id = info.id;
        await initialTeamModel.deleteOne({id});
    }
}

export async function findEnterpriseInitialTeamsByParamToPage(param, skipCount:number) {
    return await initialTeamModel.find(param).skip(skipCount).limit(10);
}

export async function findEnterpriseInitialTeamsCountByParamToPage(param) {
    return await initialTeamModel.find(param).countDocuments();
}

export async function findEnterpriseInitialTeamsByParam(param) {
    return await initialTeamModel.find(param);
}

export async function statsEnterpriseInitalTeamsType() {
    let statsCountList = await initialTeamModel.aggregate([
        {"$group":{_id:"$type", count:{"$sum":1} } }
    ]);
    return statsCountList;
}