/**
 * 知识产权主要逻辑
 * 作者:lxm
 */

import { ENTERPRISENODEENUM, POINTTYPEENUM } from "../../../config/pointConfig";
import * as enterpriseData from "../../../data/enterprise/enterprise";
import { addPoint } from "../../point";

/**
 * 校验参数是否为空
 * @param param 参数 
 * @returns true就是空 
 */
function paramIsNull(param) {
    if (!param) return true;
    let isNull = false;
    if (typeof param == "object") {
        if (Array.isArray(param) ) isNull = param.length == 0;
        else isNull = Object.keys(param).length == 0;
    }
    else isNull = !param;

    return isNull;
}


/**
 * 修改企业知识产权信息
 * @param uscc 企业统一信用代码
 * @param alienPatent 海外专利个数
 * @param classIPatent 一类专利个数
 * @param secondClassPatent 二类专利个数
 * @returns isSuccess
 */
export async function updateIntellectualProperty(uscc:string, alienPatent:number, classIPatent:number, secondClassPatent:number) {
    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);

    if (enterpriseInfo.alienPatent != alienPatent) {
        addPoint(POINTTYPEENUM.企业, uscc, ENTERPRISENODEENUM.知识产权_海外专利, enterpriseInfo.alienPatent || 0, alienPatent);
    } 
    if (enterpriseInfo.classIPatent != classIPatent) {
        addPoint(POINTTYPEENUM.企业, uscc, ENTERPRISENODEENUM.知识产权_一类专利, enterpriseInfo.classIPatent || 0, classIPatent);
    } 
    if (enterpriseInfo.secondClassPatent != secondClassPatent) {
        addPoint(POINTTYPEENUM.企业, uscc, ENTERPRISENODEENUM.知识产权_二类专利, enterpriseInfo.secondClassPatent || 0, secondClassPatent);
    }

    enterpriseInfo.intellectualProperty = {alienPatent, classIPatent, secondClassPatent};
    await enterpriseInfo.save();
    
    /**红框提示 */
    if (!enterpriseInfo.tipsIntellectualProperty ) {
        enterpriseInfo.tipsIntellectualProperty = true;
    }

    return {isSuccess:true}
}


/**
 * 查询企业专利信息 
 * 回显
 * @param uscc 企业统一信用代码
 * @returns 
 */
export async function selectIntellectualProperty(uscc:string) {
    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);

    let intellectualProperty = {alienPatent:0, classIPatent:0, secondClassPatent:0};

    if (!paramIsNull(enterpriseInfo.intellectualProperty)) {
        intellectualProperty = enterpriseInfo.intellectualProperty;
    }

    return intellectualProperty;
}
