/**
 * 管理后台 数字看板  孵化器看板 风险预警 主要逻辑
 * 作者:lxm
 */

import { FUHUASTATE, TASKTYPEENUM } from "../../../../config/enum";
import { findEnterpriseCount, findEnterpriseList, findEnterpriseListToPage5, findEnterpriseTotalByFuHuaQiUscc } from "../../../../data/enterprise/enterprise";
import { findTaskListByParam } from "../../../../data/fuHuaQi/monthTask/task";
import { changeEnumValue } from "../../../../util/verificationEnum";


/**
 * 概览
 * @param uscc 
 * @returns 
 */
export async function worningTips(uscc:string) {
    let year = new Date().getFullYear();
    /**查找孵化器本年未填报 */
    let notSubmittedDataList = await findTaskListByParam({fuHuaQiUscc:uscc, year, isSubmit:false});
    let notSubmittedList = [];
    notSubmittedDataList.forEach(info => {
        let {type, month} = info;
        notSubmittedList.push({
            month:`${month}月份`,
            title:`${changeEnumValue(TASKTYPEENUM, type)}`
        });
    });

    let fuHuaQiTaskNotFillingCount = notSubmittedDataList.length;//未填报任务数

    /**查找办公地点冲突的企业 */
    let enterpriseList = await findEnterpriseList({fuHuaQiUscc:uscc});
    let distinctMap = {};

    let logonAddressDistinctList = [];
    enterpriseList.forEach(info => {
        let {uscc, name, logonAddress} = info;
        if (logonAddress && logonAddress[3]) {
            let addStr = logonAddress[3];
            if (!distinctMap[addStr]) distinctMap[addStr] = name;
            else {
                logonAddressDistinctList.push({name, target:distinctMap[addStr], addStr});
            } 
        }
    });
    let addConflictCount = logonAddressDistinctList.length;

    /**出租率异常 */
    let param = {
        fuHuaQiUscc:uscc, 
        state:FUHUASTATE.实体孵化, 
        leasedArea:0
    };
    let fuHuaQiLettingRateCoutn = await findEnterpriseCount(param);
    
    return {fuHuaQiTaskNotFillingCount, addConflictCount, fuHuaQiLettingRateCoutn};
}


/**
 * 孵化器本年未填报
 * @param uscc 
 * @param page 
 * @returns 
 */
export async function fuHuaQiTaskNotFillingList(uscc:string, page:number) {
    let year = new Date().getFullYear();
    let notSubmittedDataList = await findTaskListByParam({fuHuaQiUscc:uscc, year, isSubmit:false});
    let notSubmittedList = [];
    notSubmittedDataList.forEach(info => {
        let {type, month} = info;
        notSubmittedList.push({
            month:`${month}月份`,
            title:`${changeEnumValue(TASKTYPEENUM, type)}`
        });
    });

    let dataList = notSubmittedList.splice((page-1)*5,5);

    let count = notSubmittedDataList.length;

    return { count, dataList, pageCount:Math.ceil(count/5)};
}


/**
 * 孵化器旗下企业办公地点冲突的企业
 * @param uscc 
 * @param page 
 */
export async function fuHuQiAddConflictList(uscc:string, page:number) {
    let enterpriseList = await findEnterpriseList({fuHuaQiUscc:uscc});
    let distinctMap = {};
    let logonAddressDistinctList = [];
    enterpriseList.forEach(info => {
        let {uscc, name, logonAddress} = info;
        if (logonAddress && logonAddress[3]) {
            let addStr = logonAddress[3];
            if (!distinctMap[addStr]) distinctMap[addStr] = name;
            else {
                logonAddressDistinctList.push({name, target:distinctMap[addStr], addStr});
            } 
        }
    });

    let count = logonAddressDistinctList.length;
    let dataList = logonAddressDistinctList.splice((page-1)*5, 5);

    return { count, dataList, pageCount:Math.ceil(count/5)};
}


/**
 * 孵化器出租率异常
 * 实际上只是返回该孵化器下实孵企业孵化面积为0的 2023.8.4需求
 * @param uscc 
 * @param page 
 */
export async function fuHuaQiLettingRateList(uscc:string, page:number) {
    let param = {
        fuHuaQiUscc:uscc, 
        state:FUHUASTATE.实体孵化, 
        leasedArea:0
    };
    let list = await findEnterpriseListToPage5(param, (page-1)*5);
    let count = await findEnterpriseCount(param);
    let dataList = [];
    list.forEach(info => {
        let {name, leasedArea} = info;
        dataList.push({name, leasedArea, bcos:"租赁面积为0"});
    });

    return {dataList, count, pageCount:Math.ceil(count/5)};
}