/**
 * 管理后台 数字看板  孵化器看板 基本信息 主要逻辑
 * 作者:lxm
 */

import { GuanWeiHuiChnageFuHuaQiBaseConfig } from "../../../../config/eccParam/admin";
import { OrganizationParamUpdateConfig } from "../../../../config/eccParam/fuHuaQi";
import { FUHUAINDUSTRY, FUHUAQILV, INSTITUTIONALNATURE, OPERATIONMODEL, SCOREWAYS } from "../../../../config/enum";
import { ERRORENUM } from "../../../../config/errorEnum";
import { StarConfig } from "../../../../config/scoreConfig";
import { findFuHuaQiByUSCC } from "../../../../data/fuHuaQi/fuhuaqi";
import * as i18nRegisterData from "../../../../data/fuHuaQi/instituQualify/i18nRegister";
import * as zjBeyondLayoutData from "../../../../data/fuHuaQi/instituQualify/zjBeyondLayout";
import * as scoreData from "../../../../data/fuHuaQi/score";
import { BizError } from "../../../../util/bizError";
import { checkChange } from "../../../../util/piecemeal";
import { eccEnumValue } from "../../../../util/verificationEnum";
import { eccFormParam } from "../../../../util/verificationParam";
import { updateScore } from "../../../mobileFuHuaQi/fuHuaQi/score";

/**
 * 获取孵化器基本信息
 * @param uscc 孵化器统一信用代码
 */
export async function fuHuaQiBaseData(uscc:string) {
    let fuHuaQiInfo = await findFuHuaQiByUSCC(uscc);
    if (!fuHuaQiInfo || !fuHuaQiInfo.uscc) throw new BizError(ERRORENUM.不合规操作);

    /**基本信息 */
    let name = fuHuaQiInfo.name; //名称
    let acreageTotal = fuHuaQiInfo.acreageTotal; //孵化器总面积(㎡)
    let incubatedAcreage = fuHuaQiInfo.incubatedAcreage; //在孵面积(㎡)
    let acreagePersonalUse = fuHuaQiInfo.acreagePersonalUse; //孵化器自用面积(㎡)
    let foundingTeamCount = fuHuaQiInfo.foundingTeam ? fuHuaQiInfo.foundingTeam.length : 0; //创业团队
    let hatchingGroundCount = fuHuaQiInfo.hatchingGround ? fuHuaQiInfo.hatchingGround.length : 0; //经备案孵化场地
    //张江以为布局数量+国际化登记数量=基地数量
    let baseCount = await i18nRegisterData.getCount(uscc) + await zjBeyondLayoutData.getCount(uscc);

    const BaseData = {
        name, acreageTotal, incubatedAcreage, acreagePersonalUse, foundingTeamCount, hatchingGroundCount, baseCount
    };
    const FuHuaQiData = {
        operationName:fuHuaQiInfo.operationName,//运营机构名称  不可修改
        name,//名称
        uscc:fuHuaQiInfo.uscc,//统一信用代码 也是登录账号 不可修改
        lv:fuHuaQiInfo.lv,//孵化器级别
        identificationTime:fuHuaQiInfo.identificationTime,//认定时间
        industry:fuHuaQiInfo.industry,//孵化领域
        institutionalNature:fuHuaQiInfo.institutionalNature,//机构性质
        isCreatePTP:fuHuaQiInfo.isCreatePTP,//是成立创投基金
        liaison:fuHuaQiInfo.liaison,//联系人
        personInCharge:fuHuaQiInfo.personInCharge,//负责人
        personInChargePhone:fuHuaQiInfo.personInChargePhone,//负责人联系电话
        introduction:fuHuaQiInfo.introduction,//孵化器简介
    };

    let scoreInfoData = await scoreData.findFuHuaQiScoreInfo(uscc);

    let { startScore, myDataScore, baseDataScore, myEnterpriseScore, taskScore } = scoreInfoData;
    let count = Math.ceil(startScore +myDataScore +baseDataScore +myEnterpriseScore +taskScore);

    let newStar = starCount(count);

    let keyList = [
        "name", "acreageTotal", "incubatedAcreage", "acreagePersonalUse", "foundingTeamCount", "hatchingGroundCount",
        "operationName", "name", "uscc", "lv", "identificationTime", "industry", "institutionalNature", "isParticipateInPTP", "liaison", "personInCharge", "personInChargePhone",
    ];

    let notCount = 0;
    keyList.forEach(key => {
        if (fuHuaQiInfo[key] == undefined) notCount += 1;
    });

    const ScoreData = { score:count, star:newStar, infoIntegrity:Math.ceil((notCount/keyList.length)*10000)/100 };

    const PTPData = !fuHuaQiInfo.isCreatePTP ? {} : {
        scalePTP: fuHuaQiInfo.scalePTP,//基金规模
        participatingFundCompany: fuHuaQiInfo.isParticipateInPTP ? fuHuaQiInfo.participatingFundCompany : '',//参股基金公司名
    };

    return {baseData:BaseData, PTPData, scoreData:ScoreData, fuHuaQiData:FuHuaQiData};
}

/**
 * 根据分数算星数
 * @param socre 分数
 * @returns 星数
 */
function starCount(socre:number) {
    let star = 1;
    for (let i = 0; i < StarConfig.length; i++) {
        let {name, value, starNum} = StarConfig[i];
        if ( socre <= value ) {
            star = starNum;
            break;
        }
    }
    return star;
}


/**
 * 修改孵化器基本信息
 * @param uscc
 * @param param
 */
export async function updateFuHuaQiBaseData(uscc:string, param) {
    /**校验表单内容 */
    eccFormParam("更新孵化器机构信息数据",  GuanWeiHuiChnageFuHuaQiBaseConfig, param);

    /**校验是否符合枚举范围 */
    if (param.lv) eccEnumValue("管委会更新孵化器信息", " 孵化器级别 ", FUHUAQILV, param.lv);
    if (param.industry) eccEnumValue("管委会更新孵化器信息", " 领域 ", FUHUAINDUSTRY, param.industry);
    if (param.institutionalNature) eccEnumValue("更新孵化器机构信息数据", " 机构性质 ", INSTITUTIONALNATURE, param.institutionalNature);
    if (param.operationModel && param.operationModel.length) eccEnumValue("更新孵化器机构信息数据", " 运营模式 ", OPERATIONMODEL, param.operationModel);
    //限制企业简介长度
    if (param.introduction) {
        if (param.introduction.length > 200) throw new BizError(ERRORENUM.字数超过200限制, "更新孵化器机构信息数据 孵化器简介");
    }
    
    let baseDataInfo = await findFuHuaQiByUSCC(param.uscc);
    
    /**赋值内容  */
    let changeList = checkChange(param, baseDataInfo);
    for (let i = 0; i < changeList.length; i++) {
        let key = changeList[i];
        if (key == "operationName" || key == "uscc") continue;
        baseDataInfo[key] = param[key];
    }

    await baseDataInfo.save();

    /**更新分数 */
    await updateScore(param.uscc, SCOREWAYS.我的信息, false);
  
    return {isSuccess:true};
}