/**
 * 总路由入口
 */

import * as publicRouters from './public';
import * as mobileClientEnterpriseRouters from './mobileClient/enterprise';
import * as mobileClientFinancingRouters from './mobileClient/financing';
import * as mobileClientFuHuaQiRouters from './mobileClient/fuHuaQi';
import * as mobileClientMonthRouters from './mobileClient/month';
import * as mobileClientUserRouters from './mobileClient/user';

import * as adminEnterpriseRouters from './admin/enterprise';
import * as adminFuHuaQiRouters from './admin/fuHuaQi';
import * as adminUserRouters from './admin/user';

import * as provideRouters from './provide';


export function setRouter(httpServer){
    /**下拉框等公用 路由 */
    publicRouters.setRouter(httpServer);
    /**小程序端 孵化器入口路由 */
    mobileClientEnterpriseRouters.setRouter(httpServer);
    mobileClientFinancingRouters.setRouter(httpServer);
    mobileClientFuHuaQiRouters.setRouter(httpServer);
    mobileClientMonthRouters.setRouter(httpServer);
    mobileClientUserRouters.setRouter(httpServer);
    /**管理后台端 入口路由 */
    adminEnterpriseRouters.setRouter(httpServer);
    adminFuHuaQiRouters.setRouter(httpServer);
    adminUserRouters.setRouter(httpServer);
    /**系统维护 入口路由 */
    provideRouters.setRouter(httpServer);
}