/**
 * 私有路由  用于维护迭代过程中造成的缺失数据
 * 注意：需要保证每个路由都使用  checkInterior  中间件
 */

import * as asyncHandler from 'express-async-handler';
import * as provideBiz from '../biz/admin/provide';
import { checkInterior } from '../middleware/user';


export function setRouter(httpServer) {
    httpServer.post('/admin/provide/task/add12',checkInterior, asyncHandler(provideLastTask));//已经弃用
    httpServer.post('/admin/provide/enterprise/updatestate',checkInterior, asyncHandler(updateEnterpriseState));
    httpServer.post('/admin/provide/task/updatetaskyear',checkInterior, asyncHandler(updateTaskYear));
    httpServer.post('/admin/provide/task/initScore',checkInterior, asyncHandler(initScore));
}

/**
 * 手动发放一月份任务
 * 使用情况：1.0使用  已弃用
 * @param req 
 * @param res 
 */
async function provideLastTask(req, res) {
    await provideBiz.provideLastTask();
    res.success({isUsccess:true});
}


/**
 * 添加任务的年份字段  用于筛选数据 
 * 使用情况：2.0使用
 * @param req 
 * @param res 
 */
async function updateTaskYear(req, res) {
    await provideBiz.updateFuHuaQiTaskYear();
    res.success({isUsccess:true});
}


/**
 * 更新企业的状态为 在孵企业
 * 使用情况：2.0使用
 * @param req 
 * @param res 
 */
async function updateEnterpriseState(req, res) {
    await provideBiz.updateEnterpriseFuHuaState();
    res.success({isUsccess:true});
}


/**
 * 初始化所有孵化器分数
 * 使用情况：2.0使用
 * 备注：只能调用一次
 * @param req 
 * @param res 
 */
async function initScore(req, res) {
    await provideBiz.initScoreData();
    res.success({isUsccess:true});
}