/**
 * 小程序端  孵化器入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../../biz/mobileFuHuaQi/fuHuaQi/user';
import { eccReqParamater } from '../../util/verificationParam';
import { checkFuHuaQiToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/login', asyncHandler(login));
    httpServer.post('/fuhuaqi/logout', checkFuHuaQiToken, asyncHandler(logout));
    httpServer.post('/fuhuaqi/login/firstupdate', checkFuHuaQiToken, asyncHandler(firstUpdatePwd));
    httpServer.post('/fuhuaqi/changepwd', checkFuHuaQiToken, asyncHandler(changePwd));
    httpServer.post('/fuhuaqi/binduser', checkFuHuaQiToken, asyncHandler(bindUser));
    httpServer.post('/fuhuaqi/bindlist', checkFuHuaQiToken, asyncHandler(bindList));
    httpServer.post('/fuhuaqi/changeuser', checkFuHuaQiToken, asyncHandler(changeUser));

}


/**
 * 孵化器登录 
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {uscc:'String', pwd:'String'};
    let {uscc, pwd} = eccReqParamater(reqConf, req.body);
    
    let result = await userBiz.login(uscc, pwd);

    res.success(result);
}


/**
 * 孵化器退出登录
 * @param req 
 * @param res 
 */
async function logout(req, res) {
    const Uscc = req.headers.uscc;
    let result = await userBiz.logout(Uscc);
    res.success(result);
}


/**
 * 孵化器首次登录 
 * @param req 
 * @param res 
 */
async function firstUpdatePwd(req, res) {
    let reqConf = {confirmPwd:'String', pwd:'String' };
    let {confirmPwd, pwd} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    
    let result = await userBiz.firstLoginChangePwd(Uscc, pwd, confirmPwd);

    res.success(result);
}


/**
 * 修改密码
 * @param req 
 * @param res 
 */
async function changePwd(req, res) {
    let reqConf = {confirmPwd:'String', newPwd:'String', pwd:'String' };
    let {confirmPwd, newPwd, pwd} = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await userBiz.changePassword(Uscc, pwd, newPwd, confirmPwd); 

    res.success(result);
}


/**
 * 绑定账号
 * @param req 
 * @param res 
 */
async function bindUser(req, res) {
    let reqConf = {bindUscc:'String', bindPwd:'String', code:'String' };
    let {bindUscc, bindPwd, code} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;

    let result = await userBiz.bindFuHuaQi(Uscc, bindUscc, bindPwd, code); 

    res.success(result);
}


/**
 * 已绑定的账号列表
 * @param req 
 * @param res 
 */
async function bindList(req, res) {

    let reqConf = { code:'String' };
    let { code} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    
    let result = await userBiz.bindUserList(Uscc, code); 

    res.success(result);
}


/**
 * 切换账号账号
 * @param req 
 * @param res 
 */
async function changeUser(req, res) {

    let reqConf = { targetUscc:'String' };
    let { targetUscc} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    
    let result = await userBiz.changeUser(Uscc, targetUscc); 

    res.success(result);
}
