/**
 * 小程序端  孵化器入口  企业相关路由
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseBiz from '../../biz/mobileFuHuaQi/enterprise/enterprise';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import { FUHUASTATE } from '../../config/enum';

export function setRouter(httpServer) {
    /**新注册企业 或 新迁入企业 */
    httpServer.post('/fuhuaqi/enterprise/register', checkFuHuaQiToken, asyncHandler(registerEnterprise));
    httpServer.post('/fuhuaqi/enterprise/updateregister', checkFuHuaQiToken, asyncHandler(updateRegisterEnterprise));
    httpServer.post('/fuhuaqi/enterprise/move', checkFuHuaQiToken, asyncHandler(moveInEnterprise));
    httpServer.post('/fuhuaqi/enterprise/updatemove', checkFuHuaQiToken, asyncHandler(updateMoveInEnterprise));
    httpServer.post('/fuhuaqi/enterprise/select', checkFuHuaQiToken, asyncHandler(selectEnterpriseInfo));
    httpServer.post('/fuhuaqi/enterprise/delete', checkFuHuaQiToken, asyncHandler(delEnterpriseInfo));
    /**我的企业 */
    httpServer.post('/fuhuaqi/myenterprise/list', checkFuHuaQiToken, asyncHandler(myEnterpriseList));
    httpServer.post('/fuhuaqi/myenterprise/moveoutlist', checkFuHuaQiToken, asyncHandler(myEnterpriseMoveOutList));
    httpServer.post('/fuhuaqi/myenterprise/info', checkFuHuaQiToken, asyncHandler(myEnterpriseInfo));
    httpServer.post('/fuhuaqi/myenterprise/update', checkFuHuaQiToken, asyncHandler(updateMyEnterpriseInfo));
    httpServer.post('/fuhuaqi/myenterprise/replenish/create', checkFuHuaQiToken, asyncHandler(replenishCreate));
    httpServer.post('/fuhuaqi/myenterprise/replenish/input', checkFuHuaQiToken, asyncHandler(replenishInPut));
    /**我的企业 修改 */
    httpServer.post('/fuhuaqi/myenterprise/update/physical', checkFuHuaQiToken, asyncHandler(updatePhysical));
    httpServer.post('/fuhuaqi/myenterprise/update/virtual', checkFuHuaQiToken, asyncHandler(updateVirtual));
    httpServer.post('/fuhuaqi/myenterprise/update/moveout', checkFuHuaQiToken, asyncHandler(updateMoveOut));
    /**我的企业信息 回显 */
    // httpServer.post('/fuhuaqi/myenterprise//moveout', checkFuHuaQiToken, asyncHandler(updateMoveOut));
}


/**
 * 添加新注册的企业信息
 * 1.0
 * @param req 
 * @param res 
 */
async function registerEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.registerEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 修改新注册的企业信息
 * 1.0
 * @param req 
 * @param res 
 */
async function updateRegisterEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateRegisterEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 添加迁入的企业信息 
 * 1.0
 * @param req 
 * @param res 
 */
 async function moveInEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.moveInEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 修改迁入企业登记信息 
 * 1.0
 * @param req 
 * @param res 
 */
async function updateMoveInEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateMoveInEnterprise(Uscc, form);
    res.success(result);
}


/**
 * 查询迁入企业登记信息或新建企业登录信息 
 * 1.0
 * 回显
 * @param req 
 * @param res 
 */
 async function selectEnterpriseInfo(req, res) {
    /*这里改成了用DraftId,为了不改前端 依然使用uscc这个参数名称*/
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body); 

    let result = await enterpriseBiz.getEnterpriseByDraftId(uscc);
    res.success(result);
}


/**
 * 删除迁入企业登记信息或新建企业登录信息
 * 1.0
 * @param req 
 * @param res 
 */
async function delEnterpriseInfo(req, res) {
     /*这里改成了用DraftId,为了不改前端 依然使用uscc这个参数名称*/
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);

    let result = await enterpriseBiz.deleteEnterpriseByDraftId(uscc);
    res.success(result);
}


/**
 * 我的企业列表
 * 小程序端 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseList(req, res) {
    let reqConf = {name: 'String', state:"Number", page:"Number" };
    let { name, state, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await enterpriseBiz.myEnterprise(Uscc, state, name, page);

    res.success(data);
}


/**
 * 我的企业列表迁出列表
 * 小程序端 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseMoveOutList(req, res) {
    let reqConf = {name: 'String', page:"Number" };
    let { name, page } = eccReqParamater(reqConf, req.body, ["name"]);
    const Uscc = req.headers.uscc;
    let data = await enterpriseBiz.myEnterprise(Uscc, FUHUASTATE.迁出, name, page);

    res.success(data);
}


/**
 * 企业基本信息
 * 我的企业列表中的企业基本信息
 * 回显
 * 2.0
 * @param req 
 * @param res 
 */
async function myEnterpriseInfo(req, res) {
    let reqConf = {uscc: 'String' };
    let { uscc } = eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;
    let result = await enterpriseBiz.getMyEnterpriseBaseInfo(FuHuaQiUscc, uscc);
    res.success(result);
}


/**
 * 修改企业孵化状态 修改为实体
 * 2.0
 * @param req 
 * @param res 
 */
async function updatePhysical(req, res) {
    let reqConf = {leasedArea: 'Number', uscc:"String" };
    let { leasedArea, uscc } = await eccReqParamater(reqConf, req.body);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await enterpriseBiz.updatePhysicalInfo(FuHuaQiUscc, uscc, leasedArea);

    res.success(result);
}


/**
 * 修改企业孵化状态 修改为虚拟
 * 2.0
 * @param req 
 * @param res 
 */
async function updateVirtual(req, res) {
    let reqConf = {virtualCause: 'Number', uscc:"String" , virtualCauseDes:"String"};
    let { virtualCause, uscc, virtualCauseDes} = await eccReqParamater(reqConf, req.body, ["virtualCauseDes"]);
    const FuHuaQiUscc = req.headers.uscc;

    let result = await enterpriseBiz.updateVirtualInfo(FuHuaQiUscc, uscc, virtualCauseDes, virtualCause);

    res.success(result);
}


/**
 * 修改企业孵化状态 修改为迁出
 * 2.0
 * @param req 
 * @param res 
 */
async function updateMoveOut(req, res) {
    let reqConf = {moveOutType: 'Number', uscc:"String" , moveOutCause:"[Number]"};
    let { moveOutType, uscc, moveOutCause} = await eccReqParamater(reqConf, req.body, );
    const FuHuaQiUscc = req.headers.uscc;

    let result = await enterpriseBiz.updateMoveOutInfo(FuHuaQiUscc, uscc, moveOutType, moveOutCause);

    res.success(result);
}


/**
 * 修改我的企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function updateMyEnterpriseInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateMyEnterpriseBaseInfo(Uscc, form);
    res.success(result);
}


/**
 * 补录 新注册企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function replenishCreate(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.replenishMyEnterpriseCreateInfo(Uscc, form);
    res.success(result);
}


/**
 * 补录 新迁入企业信息
 * 2.0
 * @param req 
 * @param res 
 */
async function replenishInPut(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.replenishMyEnterpriseInPutInfo(Uscc, form);
    res.success(result);
}