/**
 * 得分表
 * 记录孵化器分数
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const fuHuaQiScoreSchema = new Schema({
    uscc:{type:String, index:true},//孵化器uscc
    startScore:{type:Number, default:400},//初始分 400  创建孵化器的时候要在这里加上
    lastYearStar:{type:Number, default:3},//去年星值  这里默认是3星  每年12月31日12时，需要根据分算星然后更新到这里
    myDataScore:{type:Number, default:0},//我的数据获得的分数
    baseDataScore:{type:Number, default:0},//基础数据获得的分数
    myEnterpriseScore:{type:Number, default:0},//我的企业获得的分数
    taskScore:{type:Number, default:0},//任务获得分数
    updateTime:{type:Number, default:0},//更新时间戳
    /**上一次评分 */
    lastScore:{type:Number, default:0}//在获取列表的时候要同步数据
});


var fuHuaQiScoreModel;
export function initModel(){
    fuHuaQiScoreModel = baseDB.model('fuhuaqiscore', fuHuaQiScoreSchema);
    fuHuaQiScoreModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await fuHuaQiScoreModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

export async function findFuHuaQiScoreInfo(uscc:string) {
    return await fuHuaQiScoreModel.selectOnceData({uscc});
}


/**
 * 创建分数信息
 * @param uscc 孵化器统一信用代码
 */
export async function createFuHuaQiScore(uscc:string) {
    return await fuHuaQiScoreModel.create({uscc, updateTime:new Date().valueOf() });
}


export async function initFuHuaQiScore(array) {
    return await fuHuaQiScoreModel.insertMany(array);
}

